/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.exceptions;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.fs.PathAccessDeniedException;
import org.apache.hadoop.fs.PathIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionConverter {
    private static final Logger log = LoggerFactory.getLogger(ExceptionConverter.class);

    public static IOException convertJerseyException(String verb, String targetURL, UniformInterfaceException exception) {
        Object ioe = null;
        ClientResponse response = exception.getResponse();
        if (response != null) {
            int status = response.getStatus();
            String body = "";
            try {
                if (response.hasEntity()) {
                    body = (String)response.getEntity(String.class);
                    log.error("{} {} returned status {} and body\n{}", new Object[]{verb, targetURL, status, body});
                } else {
                    log.error("{} {} returned status {} and empty body", new Object[]{verb, targetURL, status});
                }
            }
            catch (Exception e) {
                log.warn("Failed to extract body from client response", (Throwable)e);
            }
            if (status == 401 || status == 403) {
                ioe = new PathAccessDeniedException(targetURL);
            } else if (status == 400 || status == 406 || status == 415) {
                ioe = new InvalidRequestException(String.format("Bad %s request: status code %d against %s", verb, status, targetURL));
            } else if (status > 400 && status < 500) {
                ioe = new FileNotFoundException(targetURL);
            }
            if (ioe == null) {
                ioe = new PathIOException(targetURL, String.valueOf(verb) + " " + targetURL + " failed with status code : " + status + ":" + (Object)((Object)exception));
            }
        } else {
            ioe = new PathIOException(targetURL, String.valueOf(verb) + " " + targetURL + " failed: " + (Object)((Object)exception));
        }
        ioe.initCause(exception);
        return ioe;
    }

    public static IOException convertJerseyException(String verb, String targetURL, ClientHandlerException exception) {
        if (exception.getCause() instanceof IOException) {
            return (IOException)exception.getCause();
        }
        IOException ioe = new IOException(String.valueOf(verb) + " " + targetURL + " failed: " + (Object)((Object)exception));
        ioe.initCause(exception);
        return ioe;
    }
}

