/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.annotation;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.nodes.TimeRole;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metastore.api.IMetaStore;

public class OptionsResolver {
    static final Logger logger = Logger.getLogger(OptionsResolver.class.getName());

    public String[] resolveTimeSourceFormatOptions(String timeLevelType) {
        try {
            ModelAnnotation.TimeType timeType = ModelAnnotation.TimeType.valueOf((String)timeLevelType);
            if (timeType != null) {
                if (ModelAnnotation.TimeType.TimeYears.equals((Object)timeType)) {
                    return TimeRole.YEARS.formats;
                }
                if (ModelAnnotation.TimeType.TimeHalfYears.equals((Object)timeType)) {
                    return TimeRole.HALFYEARS.formats;
                }
                if (ModelAnnotation.TimeType.TimeQuarters.equals((Object)timeType)) {
                    return TimeRole.QUARTERS.formats;
                }
                if (ModelAnnotation.TimeType.TimeMonths.equals((Object)timeType)) {
                    return TimeRole.MONTHS.formats;
                }
                if (ModelAnnotation.TimeType.TimeWeeks.equals((Object)timeType)) {
                    return TimeRole.WEEKS.formats;
                }
                if (ModelAnnotation.TimeType.TimeDays.equals((Object)timeType)) {
                    return TimeRole.DAYS.formats;
                }
                if (ModelAnnotation.TimeType.TimeHours.equals((Object)timeType)) {
                    return TimeRole.HOURS.formats;
                }
                if (ModelAnnotation.TimeType.TimeMinutes.equals((Object)timeType)) {
                    return TimeRole.MINUTES.formats;
                }
                if (ModelAnnotation.TimeType.TimeSeconds.equals((Object)timeType)) {
                    return TimeRole.SECONDS.formats;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[0];
    }

    public String[] resolveMeasureFormatOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("0");
        options.add("0.00");
        options.add("#,##0");
        options.add("#,###.00");
        options.add("-#,###.00");
        options.add("(#,###.00)");
        options.add("$ #,##0");
        options.add("$ #,##0.00");
        options.add("$ -#,##0.00");
        options.add("$ (#,##0.00)");
        options.add("$ #,##0.00;(#,##0.00)");
        options.add("0 %");
        options.add("0.00 %");
        options.add("#E+#");
        options.add("0.00E+00");
        options.add("##0.0E+0");
        return options.toArray(new String[options.size()]);
    }

    public String[] resolveAggregationTypeOptions() {
        AggregationType[] types = AggregationType.values();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].equals((Object)AggregationType.NONE)) continue;
            names.add(types[i].name());
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] resolveAggregationTypeOptions(ValueMetaInterface valueMetaInterface, AnnotationType annotationType) {
        if (valueMetaInterface != null && annotationType != null && !valueMetaInterface.isNumeric() && annotationType.getType().equals((Object)ModelAnnotation.Type.CREATE_MEASURE)) {
            return new String[]{AggregationType.COUNT.toString(), AggregationType.COUNT_DISTINCT.toString()};
        }
        return this.resolveAggregationTypeOptions();
    }

    public String[] resolveBooleanOptions() {
        return new String[]{"True", "False"};
    }

    public String[] resolveAvailableFieldsOptions(TransMeta transMeta, String stepName, ModelAnnotation modelAnnotation) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        try {
            RowMetaInterface prevStepFields = transMeta.getPrevStepFields(stepName);
            for (ValueMetaInterface valueMetaInterface : prevStepFields.getValueMetaList()) {
                if (StringUtils.equals((String)modelAnnotation.getAnnotation().getField(), (String)valueMetaInterface.getName())) continue;
                names.add(valueMetaInterface.getName());
            }
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] resolveSharedDimensions(ModelAnnotationManager manager, IMetaStore metaStore) {
        try {
            ArrayList<String> values = new ArrayList<String>();
            List groups = manager.listGroups(metaStore);
            for (ModelAnnotationGroup group : groups) {
                if (!group.isSharedDimension()) continue;
                values.add(group.getName());
            }
            return values.toArray(new String[values.size()]);
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            return new String[0];
        }
    }

    public String[] resolveAttributeFormatOptions(ModelProperty.AppliesTo dataType) {
        switch (dataType) {
            case Time: {
                return new String[]{"M/d", "M/d/yy", "MM/dd/yy", "d-MMM", "d-MMM-yy", "MMM-yy", "MMMMM-yy", "MMMMM d, yyyy", "M/d/yy h:mm AM/PM", "M/d/yy h:mm", "M/d/yyyy", "d-MMM-yyyy", "h:mm", "h:mm AM/PM", "h:mm:ss", "h:mm:ss AM/PM", "[h]:mm:ss"};
            }
            case Numeric: {
                return new String[]{"0", "0.00", "#,##0", "#,###.00", "-#,###.00", "(#,###.00)", "$ #,##0", "$ #,##0.00", "$ -#,##0.00", "$ (#,##0.00)", "$ #,##0.00;(#,##0.00)", "0 %", "0.00 %", "#E+#", "0.00E+00", "##0.0E+0"};
            }
        }
        return new String[0];
    }
}

