/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.auth.HiveAuthUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableIterable;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AddForeignKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsResult;
import org.apache.hadoop.hive.metastore.api.AddPrimaryKeyRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DropConstraintRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprResult;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeType;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class HiveMetaStoreClient
implements IMetaStoreClient,
AutoCloseable {
    ThriftHiveMetastore.Iface client = null;
    private TTransport transport = null;
    private boolean isConnected = false;
    private URI[] metastoreUris;
    private final HiveMetaHookLoader hookLoader;
    protected final HiveConf conf;
    protected boolean fastpath = false;
    private String tokenStrForm;
    private final boolean localMetaStore;
    private final MetaStoreFilterHook filterHook;
    private final int fileMetadataBatchSize;
    private Map<String, String> currentMetaVars;
    private static final AtomicInteger connCount = new AtomicInteger(0);
    private int retries = 5;
    private long retryDelaySeconds = 0L;
    protected static final Logger LOG = LoggerFactory.getLogger((String)"hive.metastore");

    public HiveMetaStoreClient(HiveConf conf) throws MetaException {
        this(conf, null, true);
    }

    public HiveMetaStoreClient(HiveConf conf, HiveMetaHookLoader hookLoader) throws MetaException {
        this(conf, hookLoader, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HiveMetaStoreClient(HiveConf conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        this.hookLoader = hookLoader;
        this.conf = conf == null ? (conf = new HiveConf(HiveMetaStoreClient.class)) : new HiveConf(conf);
        this.filterHook = this.loadFilterHooks();
        this.fileMetadataBatchSize = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_OBJECTS_MAX);
        String msUri = conf.getVar(HiveConf.ConfVars.METASTOREURIS);
        this.localMetaStore = HiveConfUtil.isEmbeddedMetaStore((String)msUri);
        if (this.localMetaStore) {
            if (!allowEmbedded.booleanValue()) {
                throw new MetaException("Embedded metastore is not allowed here. Please configure " + HiveConf.ConfVars.METASTOREURIS.varname + "; it is currently set to [" + msUri + "]");
            }
            if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH)) {
                this.client = new HiveMetaStore.HMSHandler("hive client", this.conf, true);
                this.fastpath = true;
            } else {
                this.client = HiveMetaStore.newRetryingHMSHandler("hive client", this.conf, true);
            }
            this.isConnected = true;
            this.snapshotActiveConf();
            return;
        }
        if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH)) {
            throw new RuntimeException("You can't set hive.metastore.fastpath to true when you're talking to the thrift metastore service.  You must run the metastore locally.");
        }
        this.retries = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES);
        this.retryDelaySeconds = conf.getTimeVar(HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY, TimeUnit.SECONDS);
        if (conf.getVar(HiveConf.ConfVars.METASTOREURIS) == null) {
            LOG.error("NOT getting uris from conf");
            throw new MetaException("MetaStoreURIs not found in conf file");
        }
        String[] metastoreUrisString = conf.getVar(HiveConf.ConfVars.METASTOREURIS).split(",");
        this.metastoreUris = new URI[metastoreUrisString.length];
        try {
            int i = 0;
            for (String s : metastoreUrisString) {
                URI tmpUri = new URI(s);
                if (tmpUri.getScheme() == null) {
                    throw new IllegalArgumentException("URI: " + s + " does not have a scheme");
                }
                this.metastoreUris[i++] = tmpUri;
            }
            if (HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORESELECTION).equalsIgnoreCase("RANDOM")) {
                List<URI> uriList = Arrays.asList(this.metastoreUris);
                Collections.shuffle(uriList);
                this.metastoreUris = (URI[])uriList.toArray();
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
        }
        this.open();
    }

    private MetaStoreFilterHook loadFilterHooks() throws IllegalStateException {
        Class authProviderClass = this.conf.getClass(HiveConf.ConfVars.METASTORE_FILTER_HOOK.varname, DefaultMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        String msg = "Unable to create instance of " + authProviderClass.getName() + ": ";
        try {
            Constructor constructor = authProviderClass.getConstructor(HiveConf.class);
            return (MetaStoreFilterHook)constructor.newInstance(this.conf);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
    }

    private void promoteRandomMetaStoreURI() {
        if (this.metastoreUris.length <= 1) {
            return;
        }
        Random rng = new Random();
        int index = rng.nextInt(this.metastoreUris.length - 1) + 1;
        URI tmp = this.metastoreUris[0];
        this.metastoreUris[0] = this.metastoreUris[index];
        this.metastoreUris[index] = tmp;
    }

    @VisibleForTesting
    public TTransport getTTransport() {
        return this.transport;
    }

    @Override
    public boolean isLocalMetaStore() {
        return this.localMetaStore;
    }

    @Override
    public boolean isCompatibleWith(HiveConf conf) {
        Map<String, String> currentMetaVarsCopy = this.currentMetaVars;
        if (currentMetaVarsCopy == null) {
            return false;
        }
        boolean compatible = true;
        for (HiveConf.ConfVars oneVar : HiveConf.metaVars) {
            String oldVar = currentMetaVarsCopy.get(oneVar.varname);
            String newVar = conf.get(oneVar.varname, "");
            if (oldVar != null && !(oneVar.isCaseSensitive() ? !oldVar.equals(newVar) : !oldVar.equalsIgnoreCase(newVar))) continue;
            LOG.info("Mestastore configuration " + oneVar.varname + " changed from " + oldVar + " to " + newVar);
            compatible = false;
        }
        return compatible;
    }

    @Override
    public void setHiveAddedJars(String addedJars) {
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDJARS, (String)addedJars);
    }

    @Override
    public void reconnect() throws MetaException {
        if (this.localMetaStore) {
            throw new MetaException("For direct MetaStore DB connections, we don't support retries at the client level.");
        }
        this.close();
        if (HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORESELECTION).equalsIgnoreCase("RANDOM")) {
            this.promoteRandomMetaStoreURI();
        }
        this.open();
    }

    @Override
    public void alter_table(String dbname, String tbl_name, Table new_tbl) throws InvalidOperationException, MetaException, TException {
        this.alter_table_with_environmentContext(dbname, tbl_name, new_tbl, null);
    }

    @Override
    public void alter_table(String defaultDatabaseName, String tblName, Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        EnvironmentContext environmentContext = new EnvironmentContext();
        if (cascade) {
            environmentContext.putToProperties("CASCADE", "true");
        }
        this.alter_table_with_environmentContext(defaultDatabaseName, tblName, table, environmentContext);
    }

    @Override
    public void alter_table_with_environmentContext(String dbname, String tbl_name, Table new_tbl, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        this.client.alter_table_with_environment_context(dbname, tbl_name, new_tbl, envContext);
    }

    @Override
    public void renamePartition(String dbname, String name, List<String> part_vals, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.client.rename_partition(dbname, name, part_vals, newPart);
    }

    private void open() throws MetaException {
        this.isConnected = false;
        TTransportException tte = null;
        boolean useSSL = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_METASTORE_USE_SSL);
        boolean useSasl = this.conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL);
        boolean useFramedTransport = this.conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_FRAMED_TRANSPORT);
        boolean useCompactProtocol = this.conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_COMPACT_PROTOCOL);
        int clientSocketTimeout = (int)this.conf.getTimeVar(HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT, TimeUnit.MILLISECONDS);
        for (int attempt = 0; !this.isConnected && attempt < this.retries; ++attempt) {
            for (URI store : this.metastoreUris) {
                LOG.info("Trying to connect to metastore with URI " + store);
                try {
                    if (useSasl) {
                        try {
                            HadoopThriftAuthBridge.Client authBridge = ShimLoader.getHadoopThriftAuthBridge().createClient();
                            String tokenSig = this.conf.getVar(HiveConf.ConfVars.METASTORE_TOKEN_SIGNATURE);
                            this.tokenStrForm = Utils.getTokenStrForm((String)tokenSig);
                            this.transport = new TSocket(store.getHost(), store.getPort(), clientSocketTimeout);
                            if (this.tokenStrForm != null) {
                                this.transport = authBridge.createClientTransport(null, store.getHost(), "DIGEST", this.tokenStrForm, this.transport, MetaStoreUtils.getMetaStoreSaslProperties(this.conf));
                            }
                            String principalConfig = this.conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL);
                            this.transport = authBridge.createClientTransport(principalConfig, store.getHost(), "KERBEROS", null, this.transport, MetaStoreUtils.getMetaStoreSaslProperties(this.conf));
                        }
                        catch (IOException ioe) {
                            LOG.error("Couldn't create client transport", (Throwable)ioe);
                            throw new MetaException(ioe.toString());
                        }
                    } else {
                        if (useSSL) {
                            try {
                                String trustStorePath = this.conf.getVar(HiveConf.ConfVars.HIVE_METASTORE_SSL_TRUSTSTORE_PATH).trim();
                                if (trustStorePath.isEmpty()) {
                                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_METASTORE_SSL_TRUSTSTORE_PATH.varname + " Not configured for SSL connection");
                                }
                                String trustStorePassword = ShimLoader.getHadoopShims().getPassword((Configuration)this.conf, HiveConf.ConfVars.HIVE_METASTORE_SSL_TRUSTSTORE_PASSWORD.varname);
                                this.transport = HiveAuthUtils.getSSLSocket((String)store.getHost(), (int)store.getPort(), (int)clientSocketTimeout, (String)trustStorePath, (String)trustStorePassword);
                                LOG.info("Opened an SSL connection to metastore, current connections: " + connCount.incrementAndGet());
                            }
                            catch (IOException e) {
                                throw new IllegalArgumentException(e);
                            }
                            catch (TTransportException e) {
                                tte = e;
                                throw new MetaException(e.toString());
                            }
                        } else {
                            this.transport = new TSocket(store.getHost(), store.getPort(), clientSocketTimeout);
                        }
                        if (useFramedTransport) {
                            this.transport = new TFramedTransport(this.transport);
                        }
                    }
                    Object protocol = useCompactProtocol ? new TCompactProtocol(this.transport) : new TBinaryProtocol(this.transport);
                    this.client = new ThriftHiveMetastore.Client((TProtocol)protocol);
                    try {
                        if (!this.transport.isOpen()) {
                            this.transport.open();
                            LOG.info("Opened a connection to metastore, current connections: " + connCount.incrementAndGet());
                        }
                        this.isConnected = true;
                    }
                    catch (TTransportException e) {
                        tte = e;
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Failed to connect to the MetaStore Server...", (Throwable)e);
                        }
                        LOG.warn("Failed to connect to the MetaStore Server...");
                    }
                    if (this.isConnected && !useSasl && this.conf.getBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI)) {
                        try {
                            UserGroupInformation ugi = Utils.getUGI();
                            this.client.set_ugi(ugi.getUserName(), Arrays.asList(ugi.getGroupNames()));
                        }
                        catch (LoginException e) {
                            LOG.warn("Failed to do login. set_ugi() is not successful, Continuing without it.", (Throwable)e);
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to find ugi of client set_ugi() is not successful, Continuing without it.", (Throwable)e);
                        }
                        catch (TException e) {
                            LOG.warn("set_ugi() not successful, Likely cause: new client talking to old server. Continuing without it.", (Throwable)e);
                        }
                    }
                }
                catch (MetaException e) {
                    LOG.error("Unable to connect to metastore with URI " + store + " in attempt " + attempt, (Throwable)((Object)e));
                }
                if (this.isConnected) break;
            }
            if (this.isConnected || this.retryDelaySeconds <= 0L) continue;
            try {
                LOG.info("Waiting " + this.retryDelaySeconds + " seconds before next connection attempt.");
                Thread.sleep(this.retryDelaySeconds * 1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isConnected) {
            throw new MetaException("Could not connect to meta store using any of the URIs provided. Most recent failure: " + org.apache.hadoop.util.StringUtils.stringifyException(tte));
        }
        this.snapshotActiveConf();
        LOG.info("Connected to metastore.");
    }

    private void snapshotActiveConf() {
        this.currentMetaVars = new HashMap<String, String>(HiveConf.metaVars.length);
        for (HiveConf.ConfVars oneVar : HiveConf.metaVars) {
            this.currentMetaVars.put(oneVar.varname, this.conf.get(oneVar.varname, ""));
        }
    }

    @Override
    public String getTokenStrForm() throws IOException {
        return this.tokenStrForm;
    }

    @Override
    public void close() {
        this.isConnected = false;
        this.currentMetaVars = null;
        try {
            if (null != this.client) {
                this.client.shutdown();
            }
        }
        catch (TException e) {
            LOG.debug("Unable to shutdown metastore client. Will try closing transport directly.", (Throwable)e);
        }
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
            LOG.info("Closed a connection to metastore, current connections: " + connCount.decrementAndGet());
        }
    }

    @Override
    public void setMetaConf(String key, String value) throws TException {
        this.client.setMetaConf(key, value);
    }

    @Override
    public String getMetaConf(String key) throws TException {
        return this.client.getMetaConf(key);
    }

    @Override
    public Partition add_partition(Partition new_part) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.add_partition(new_part, null);
    }

    public Partition add_partition(Partition new_part, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        Partition p = this.client.add_partition_with_environment_context(new_part, envContext);
        return this.fastpath ? p : this.deepCopy(p);
    }

    @Override
    public int add_partitions(List<Partition> new_parts) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (new_parts == null || new_parts.contains(null)) {
            throw new MetaException("Partitions cannot be null.");
        }
        return this.client.add_partitions(new_parts);
    }

    @Override
    public List<Partition> add_partitions(List<Partition> parts, boolean ifNotExists, boolean needResults) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (parts == null || parts.contains(null)) {
            throw new MetaException("Partitions cannot be null.");
        }
        if (parts.isEmpty()) {
            return needResults ? new ArrayList() : null;
        }
        Partition part = parts.get(0);
        AddPartitionsRequest req = new AddPartitionsRequest(part.getDbName(), part.getTableName(), parts, ifNotExists);
        req.setNeedResult(needResults);
        AddPartitionsResult result = this.client.add_partitions_req(req);
        return needResults ? this.filterHook.filterPartitions(result.getPartitions()) : null;
    }

    @Override
    public int add_partitions_pspec(PartitionSpecProxy partitionSpec) throws TException {
        if (partitionSpec == null) {
            throw new MetaException("PartitionSpec cannot be null.");
        }
        return this.client.add_partitions_pspec(partitionSpec.toPartitionSpec());
    }

    @Override
    public Partition appendPartition(String db_name, String table_name, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.appendPartition(db_name, table_name, part_vals, null);
    }

    public Partition appendPartition(String db_name, String table_name, List<String> part_vals, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        Partition p = this.client.append_partition_with_environment_context(db_name, table_name, part_vals, envContext);
        return this.fastpath ? p : this.deepCopy(p);
    }

    @Override
    public Partition appendPartition(String dbName, String tableName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.appendPartition(dbName, tableName, partName, null);
    }

    public Partition appendPartition(String dbName, String tableName, String partName, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        Partition p = this.client.append_partition_by_name_with_environment_context(dbName, tableName, partName, envContext);
        return this.fastpath ? p : this.deepCopy(p);
    }

    @Override
    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.client.exchange_partition(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
    }

    @Override
    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.client.exchange_partitions(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
    }

    @Override
    public void validatePartitionNameCharacters(List<String> partVals) throws TException, MetaException {
        this.client.partition_name_has_valid_characters(partVals, true);
    }

    @Override
    public void createDatabase(Database db) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        this.client.create_database(db);
    }

    @Override
    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.createTable(tbl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        HiveMetaHook hook = null;
        try {
            hook = this.getHook(tbl);
            if (hook != null) {
                hook.preCreateTable(tbl);
            }
            boolean success = false;
            try {
                this.create_table_with_environment_context(tbl, envContext);
                if (hook != null) {
                    hook.commitCreateTable(tbl);
                }
                success = true;
            }
            finally {
                if (!success && hook != null) {
                    hook.rollbackCreateTable(tbl);
                }
            }
        }
        finally {
            if (hook != null && hook instanceof Closeable) {
                try {
                    ((Closeable)((Object)hook)).close();
                }
                catch (Exception e) {
                    MetaStoreUtils.logAndThrowMetaException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        HiveMetaHook hook = null;
        try {
            hook = this.getHook(tbl);
            if (hook != null) {
                hook.preCreateTable(tbl);
            }
            boolean success = false;
            try {
                this.client.create_table_with_constraints(tbl, primaryKeys, foreignKeys);
                if (hook != null) {
                    hook.commitCreateTable(tbl);
                }
                success = true;
            }
            finally {
                if (!success && hook != null) {
                    hook.rollbackCreateTable(tbl);
                }
            }
        }
        finally {
            if (hook != null && hook instanceof Closeable) {
                try {
                    ((Closeable)((Object)hook)).close();
                }
                catch (Exception e) {
                    MetaStoreUtils.logAndThrowMetaException(e);
                }
            }
        }
    }

    @Override
    public void dropConstraint(String dbName, String tableName, String constraintName) throws NoSuchObjectException, MetaException, TException {
        this.client.drop_constraint(new DropConstraintRequest(dbName, tableName, constraintName));
    }

    @Override
    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws NoSuchObjectException, MetaException, TException {
        this.client.add_primary_key(new AddPrimaryKeyRequest(primaryKeyCols));
    }

    @Override
    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws NoSuchObjectException, MetaException, TException {
        this.client.add_foreign_key(new AddForeignKeyRequest(foreignKeyCols));
    }

    public boolean createType(Type type) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        return this.client.create_type(type);
    }

    @Override
    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, true, false, false);
    }

    @Override
    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    @Override
    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try {
            this.getDatabase(name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownDb) {
                throw e;
            }
            return;
        }
        if (cascade) {
            List<String> tableNameList = this.getAllTables(name);
            int tableCount = tableNameList.size();
            int maxBatchSize = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
            LOG.debug("Selecting dropDatabase method for " + name + " (" + tableCount + " tables), " + HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX.varname + "=" + maxBatchSize);
            if (tableCount > maxBatchSize) {
                LOG.debug("Dropping database in a per table batch manner.");
                this.dropDatabaseCascadePerTable(name, tableNameList, deleteData, maxBatchSize);
            } else {
                LOG.debug("Dropping database in a per DB manner.");
                this.dropDatabaseCascadePerDb(name, tableNameList, deleteData);
            }
        } else {
            this.client.drop_database(name, deleteData, cascade);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDatabaseCascadePerTable(String dbName, List<String> tableList, boolean deleteData, int maxBatchSize) throws TException {
        for (Table table : new TableIterable(this, dbName, tableList, maxBatchSize)) {
            boolean success = false;
            HiveMetaHook hook = this.getHook(table);
            if (hook == null) continue;
            try {
                hook.preDropTable(table);
                this.client.drop_table_with_environment_context(dbName, table.getTableName(), deleteData, null);
                hook.commitDropTable(table, deleteData);
                success = true;
            }
            finally {
                if (success) continue;
                hook.rollbackDropTable(table);
            }
        }
        this.client.drop_database(dbName, deleteData, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDatabaseCascadePerDb(String dbName, List<String> tableList, boolean deleteData) throws TException {
        HiveMetaHook hook;
        List<Table> tables = this.getTableObjectsByName(dbName, tableList);
        boolean success = false;
        try {
            for (Table table : tables) {
                hook = this.getHook(table);
                if (hook == null) continue;
                hook.preDropTable(table);
            }
            this.client.drop_database(dbName, deleteData, true);
            for (Table table : tables) {
                hook = this.getHook(table);
                if (hook == null) continue;
                hook.commitDropTable(table, deleteData);
            }
            success = true;
        }
        finally {
            if (!success) {
                for (Table table : tables) {
                    hook = this.getHook(table);
                    if (hook == null) continue;
                    hook.rollbackDropTable(table);
                }
            }
        }
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(db_name, tbl_name, part_vals, true, null);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, EnvironmentContext env_context) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(db_name, tbl_name, part_vals, true, env_context);
    }

    @Override
    public boolean dropPartition(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(dbName, tableName, partName, deleteData, null);
    }

    private static EnvironmentContext getEnvironmentContextWithIfPurgeSet() {
        HashMap<String, String> warehouseOptions = new HashMap<String, String>();
        warehouseOptions.put("ifPurge", "TRUE");
        return new EnvironmentContext(warehouseOptions);
    }

    public boolean dropPartition(String dbName, String tableName, String partName, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_by_name_with_environment_context(dbName, tableName, partName, deleteData, envContext);
    }

    @Override
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(db_name, tbl_name, part_vals, deleteData, null);
    }

    @Override
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws TException {
        if (options == null) {
            options = PartitionDropOptions.instance();
        }
        return this.dropPartition(db_name, tbl_name, part_vals, options.deleteData, options.purgeData ? HiveMetaStoreClient.getEnvironmentContextWithIfPurgeSet() : null);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
        if (part_vals != null) {
            for (String partVal : part_vals) {
                if (partVal != null) continue;
                throw new MetaException("The partition value must not be null.");
            }
        }
        return this.client.drop_partition_with_environment_context(db_name, tbl_name, part_vals, deleteData, envContext);
    }

    @Override
    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        RequestPartsSpec rps = new RequestPartsSpec();
        ArrayList<DropPartitionsExpr> exprs = new ArrayList<DropPartitionsExpr>(partExprs.size());
        for (ObjectPair<Integer, byte[]> partExpr : partExprs) {
            DropPartitionsExpr dpe = new DropPartitionsExpr();
            dpe.setExpr((byte[])partExpr.getSecond());
            dpe.setPartArchiveLevel((Integer)partExpr.getFirst());
            exprs.add(dpe);
        }
        rps.setExprs(exprs);
        DropPartitionsRequest req = new DropPartitionsRequest(dbName, tblName, rps);
        req.setDeleteData(options.deleteData);
        req.setNeedResult(options.returnResults);
        req.setIfExists(options.ifExists);
        if (options.purgeData) {
            LOG.info("Dropped partitions will be purged!");
            req.setEnvironmentContext(HiveMetaStoreClient.getEnvironmentContextWithIfPurgeSet());
        }
        return this.client.drop_partitions_req(req).getPartitions();
    }

    @Override
    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResult) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists).returnResults(needResult));
    }

    @Override
    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists));
    }

    @Override
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        this.dropTable(dbname, name, deleteData, ignoreUnknownTab, null);
    }

    @Override
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        EnvironmentContext envContext = null;
        if (ifPurge) {
            HashMap<String, String> warehouseOptions = null;
            warehouseOptions = new HashMap<String, String>();
            warehouseOptions.put("ifPurge", "TRUE");
            envContext = new EnvironmentContext(warehouseOptions);
        }
        this.dropTable(dbname, name, deleteData, ignoreUnknownTab, envContext);
    }

    @Override
    @Deprecated
    public void dropTable(String tableName, boolean deleteData) throws MetaException, UnknownTableException, TException, NoSuchObjectException {
        this.dropTable("default", tableName, deleteData, false, null);
    }

    @Override
    public void dropTable(String dbname, String name) throws NoSuchObjectException, MetaException, TException {
        this.dropTable(dbname, name, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        Table tbl;
        try {
            tbl = this.getTable(dbname, name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
            return;
        }
        if (MetaStoreUtils.isIndexTable(tbl)) {
            throw new UnsupportedOperationException("Cannot drop index tables");
        }
        HiveMetaHook hook = null;
        try {
            hook = this.getHook(tbl);
            if (hook != null) {
                hook.preDropTable(tbl);
            }
            boolean success = false;
            try {
                this.drop_table_with_environment_context(dbname, name, deleteData, envContext);
                if (hook != null) {
                    hook.commitDropTable(tbl, deleteData);
                }
                success = true;
            }
            catch (NoSuchObjectException e) {
                if (!ignoreUnknownTab) {
                    throw e;
                }
            }
            finally {
                if (!success && hook != null) {
                    hook.rollbackDropTable(tbl);
                }
            }
        }
        finally {
            if (hook != null && hook instanceof Closeable) {
                try {
                    ((Closeable)((Object)hook)).close();
                }
                catch (Exception e) {
                    MetaStoreUtils.logAndThrowMetaException(e);
                }
            }
        }
    }

    public boolean dropType(String type) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_type(type);
    }

    public Map<String, Type> getTypeAll(String name) throws MetaException, TException {
        LinkedHashMap<String, Type> result = null;
        Map<String, Type> fromClient = this.client.get_type_all(name);
        if (fromClient != null) {
            result = new LinkedHashMap<String, Type>();
            for (String key : fromClient.keySet()) {
                result.put(key, this.deepCopy(fromClient.get(key)));
            }
        }
        return result;
    }

    @Override
    public List<String> getDatabases(String databasePattern) throws MetaException {
        try {
            return this.filterHook.filterDatabases(this.client.get_databases(databasePattern));
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getAllDatabases() throws MetaException {
        try {
            return this.filterHook.filterDatabases(this.client.get_all_databases());
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        List<Partition> parts = this.client.get_partitions(db_name, tbl_name, max_parts);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public PartitionSpecProxy listPartitionSpecs(String dbName, String tableName, int maxParts) throws TException {
        return PartitionSpecProxy.Factory.get(this.filterHook.filterPartitionSpecs(this.client.get_partitions_pspec(dbName, tableName, maxParts)));
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws NoSuchObjectException, MetaException, TException {
        List<Partition> parts = this.client.get_partitions_ps(db_name, tbl_name, part_vals, max_parts);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, short max_parts, String user_name, List<String> group_names) throws NoSuchObjectException, MetaException, TException {
        List<Partition> parts = this.client.get_partitions_with_auth(db_name, tbl_name, max_parts, user_name, group_names);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, short max_parts, String user_name, List<String> group_names) throws NoSuchObjectException, MetaException, TException {
        List<Partition> parts = this.client.get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, user_name, group_names);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public List<Partition> listPartitionsByFilter(String db_name, String tbl_name, String filter, short max_parts) throws MetaException, NoSuchObjectException, TException {
        List<Partition> parts = this.client.get_partitions_by_filter(db_name, tbl_name, filter, max_parts);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public PartitionSpecProxy listPartitionSpecsByFilter(String db_name, String tbl_name, String filter, int max_parts) throws MetaException, NoSuchObjectException, TException {
        return PartitionSpecProxy.Factory.get(this.filterHook.filterPartitionSpecs(this.client.get_part_specs_by_filter(db_name, tbl_name, filter, max_parts)));
    }

    @Override
    public boolean listPartitionsByExpr(String db_name, String tbl_name, byte[] expr, String default_partition_name, short max_parts, List<Partition> result) throws TException {
        assert (result != null);
        PartitionsByExprRequest req = new PartitionsByExprRequest(db_name, tbl_name, ByteBuffer.wrap(expr));
        if (default_partition_name != null) {
            req.setDefaultPartitionName(default_partition_name);
        }
        if (max_parts >= 0) {
            req.setMaxParts(max_parts);
        }
        PartitionsByExprResult r = null;
        try {
            r = this.client.get_partitions_by_expr(req);
        }
        catch (TApplicationException te) {
            if (te.getType() != 1 && te.getType() != 3) {
                throw te;
            }
            throw new IMetaStoreClient.IncompatibleMetastoreException("Metastore doesn't support listPartitionsByExpr: " + te.getMessage());
        }
        if (this.fastpath) {
            result.addAll(r.getPartitions());
        } else {
            r.setPartitions(this.filterHook.filterPartitions(r.getPartitions()));
            this.deepCopyPartitions(r.getPartitions(), result);
        }
        return !r.isSetHasUnknownPartitions() || r.isHasUnknownPartitions();
    }

    @Override
    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        Database d = this.client.get_database(name);
        return this.fastpath ? d : this.deepCopy(this.filterHook.filterDatabase(d));
    }

    @Override
    public Partition getPartition(String db_name, String tbl_name, List<String> part_vals) throws NoSuchObjectException, MetaException, TException {
        Partition p = this.client.get_partition(db_name, tbl_name, part_vals);
        return this.fastpath ? p : this.deepCopy(this.filterHook.filterPartition(p));
    }

    @Override
    public List<Partition> getPartitionsByNames(String db_name, String tbl_name, List<String> part_names) throws NoSuchObjectException, MetaException, TException {
        List<Partition> parts = this.client.get_partitions_by_names(db_name, tbl_name, part_names);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions(parts));
    }

    @Override
    public Partition getPartitionWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, String user_name, List<String> group_names) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        Partition p = this.client.get_partition_with_auth(db_name, tbl_name, part_vals, user_name, group_names);
        return this.fastpath ? p : this.deepCopy(this.filterHook.filterPartition(p));
    }

    @Override
    public Table getTable(String dbname, String name) throws MetaException, TException, NoSuchObjectException {
        Table t = this.client.get_table(dbname, name);
        return this.fastpath ? t : this.deepCopy(this.filterHook.filterTable(t));
    }

    @Override
    @Deprecated
    public Table getTable(String tableName) throws MetaException, TException, NoSuchObjectException {
        Table t = this.getTable("default", tableName);
        return this.fastpath ? t : this.filterHook.filterTable(t);
    }

    @Override
    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        List<Table> tabs = this.client.get_table_objects_by_name(dbName, tableNames);
        return this.fastpath ? tabs : this.deepCopyTables(this.filterHook.filterTables(tabs));
    }

    @Override
    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, TException, InvalidOperationException, UnknownDBException {
        return this.filterHook.filterTableNames(dbName, this.client.get_table_names_by_filter(dbName, filter, maxTables));
    }

    public Type getType(String name) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopy(this.client.get_type(name));
    }

    @Override
    public List<String> getTables(String dbname, String tablePattern) throws MetaException {
        try {
            return this.filterHook.filterTableNames(dbname, this.client.get_tables(dbname, tablePattern));
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException {
        try {
            return this.filterNames(this.client.get_table_meta(dbPatterns, tablePatterns, tableTypes));
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    private List<TableMeta> filterNames(List<TableMeta> metas) throws MetaException {
        LinkedHashMap<String, TableMeta> sources = new LinkedHashMap<String, TableMeta>();
        LinkedHashMap<String, ArrayList<String>> dbTables = new LinkedHashMap<String, ArrayList<String>>();
        for (TableMeta meta : metas) {
            sources.put(meta.getDbName() + "." + meta.getTableName(), meta);
            ArrayList<String> tables = (ArrayList<String>)dbTables.get(meta.getDbName());
            if (tables == null) {
                tables = new ArrayList<String>();
                dbTables.put(meta.getDbName(), tables);
            }
            tables.add(meta.getTableName());
        }
        ArrayList<TableMeta> filtered = new ArrayList<TableMeta>();
        for (Map.Entry entry : dbTables.entrySet()) {
            for (String table : this.filterHook.filterTableNames((String)entry.getKey(), (List)entry.getValue())) {
                filtered.add((TableMeta)sources.get((String)entry.getKey() + "." + table));
            }
        }
        return filtered;
    }

    @Override
    public List<String> getAllTables(String dbname) throws MetaException {
        try {
            return this.filterHook.filterTableNames(dbname, this.client.get_all_tables(dbname));
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        try {
            return this.filterHook.filterTable(this.client.get_table(databaseName, tableName)) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    @Deprecated
    public boolean tableExists(String tableName) throws MetaException, TException, UnknownDBException {
        return this.tableExists("default", tableName);
    }

    @Override
    public List<String> listPartitionNames(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterPartitionNames(dbName, tblName, this.client.get_partition_names(dbName, tblName, max));
    }

    @Override
    public List<String> listPartitionNames(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException, NoSuchObjectException {
        return this.filterHook.filterPartitionNames(db_name, tbl_name, this.client.get_partition_names_ps(db_name, tbl_name, part_vals, max_parts));
    }

    @Override
    public int getNumPartitionsByFilter(String db_name, String tbl_name, String filter) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_num_partitions_by_filter(db_name, tbl_name, filter);
    }

    @Override
    public void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partition_with_environment_context(dbName, tblName, newPart, null);
    }

    @Override
    public void alter_partition(String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partition_with_environment_context(dbName, tblName, newPart, environmentContext);
    }

    @Override
    public void alter_partitions(String dbName, String tblName, List<Partition> newParts) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partitions_with_environment_context(dbName, tblName, newParts, null);
    }

    @Override
    public void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partitions_with_environment_context(dbName, tblName, newParts, environmentContext);
    }

    @Override
    public void alterDatabase(String dbName, Database db) throws MetaException, NoSuchObjectException, TException {
        this.client.alter_database(dbName, db);
    }

    @Override
    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        List<FieldSchema> fields = this.client.get_fields(db, tableName);
        return this.fastpath ? fields : this.deepCopyFieldSchemas(fields);
    }

    @Override
    public void createIndex(Index index, Table indexTable) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.client.add_index(index, indexTable);
    }

    @Override
    public void alter_index(String dbname, String base_tbl_name, String idx_name, Index new_idx) throws InvalidOperationException, MetaException, TException {
        this.client.alter_index(dbname, base_tbl_name, idx_name, new_idx);
    }

    @Override
    public Index getIndex(String dbName, String tblName, String indexName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.deepCopy(this.filterHook.filterIndex(this.client.get_index_by_name(dbName, tblName, indexName)));
    }

    @Override
    public List<String> listIndexNames(String dbName, String tblName, short max) throws MetaException, TException {
        return this.filterHook.filterIndexNames(dbName, tblName, this.client.get_index_names(dbName, tblName, max));
    }

    @Override
    public List<Index> listIndexes(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterIndexes(this.client.get_indexes(dbName, tblName, max));
    }

    @Override
    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest req) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_primary_keys(req).getPrimaryKeys();
    }

    @Override
    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest req) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_foreign_keys(req).getForeignKeys();
    }

    @Override
    @Deprecated
    public boolean updateTableColumnStatistics(ColumnStatistics statsObj) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.update_table_column_statistics(statsObj);
    }

    @Override
    @Deprecated
    public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.update_partition_column_statistics(statsObj);
    }

    @Override
    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.set_aggr_stats_for(request);
    }

    @Override
    public void flushCache() {
        try {
            this.client.flushCache();
        }
        catch (TException e) {
            LOG.warn("Got error flushing the cache", (Throwable)e);
        }
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException, InvalidInputException, InvalidObjectException {
        return this.client.get_table_statistics_req(new TableStatsRequest(dbName, tableName, colNames)).getTableStats();
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        return this.client.get_partitions_statistics_req(new PartitionsStatsRequest(dbName, tableName, colNames, partNames)).getPartStats();
    }

    @Override
    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.delete_partition_column_statistics(dbName, tableName, partName, colName);
    }

    @Override
    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.delete_table_column_statistics(dbName, tableName, colName);
    }

    @Override
    public List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        EnvironmentContext envCxt = null;
        String addedJars = this.conf.getVar(HiveConf.ConfVars.HIVEADDEDJARS);
        if (StringUtils.isNotBlank((String)addedJars)) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("hive.added.jars.path", addedJars);
            envCxt = new EnvironmentContext(props);
        }
        List<FieldSchema> fields = this.client.get_schema_with_environment_context(db, tableName, envCxt);
        return this.fastpath ? fields : this.deepCopyFieldSchemas(fields);
    }

    @Override
    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        return this.client.get_config_value(name, defaultValue);
    }

    @Override
    public Partition getPartition(String db, String tableName, String partName) throws MetaException, TException, UnknownTableException, NoSuchObjectException {
        Partition p = this.client.get_partition_by_name(db, tableName, partName);
        return this.fastpath ? p : this.deepCopy(this.filterHook.filterPartition(p));
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.appendPartitionByName(dbName, tableName, partName, null);
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        Partition p = this.client.append_partition_by_name_with_environment_context(dbName, tableName, partName, envContext);
        return this.fastpath ? p : this.deepCopy(p);
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitionByName(dbName, tableName, partName, deleteData, null);
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_by_name_with_environment_context(dbName, tableName, partName, deleteData, envContext);
    }

    private HiveMetaHook getHook(Table tbl) throws MetaException {
        if (this.hookLoader == null) {
            return null;
        }
        return this.hookLoader.getHook(tbl);
    }

    @Override
    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return this.client.partition_name_to_vals(name);
    }

    @Override
    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        return this.client.partition_name_to_spec(name);
    }

    private Partition deepCopy(Partition partition) {
        Partition copy = null;
        if (partition != null) {
            copy = new Partition(partition);
        }
        return copy;
    }

    private Database deepCopy(Database database) {
        Database copy = null;
        if (database != null) {
            copy = new Database(database);
        }
        return copy;
    }

    protected Table deepCopy(Table table) {
        Table copy = null;
        if (table != null) {
            copy = new Table(table);
        }
        return copy;
    }

    private Index deepCopy(Index index) {
        Index copy = null;
        if (index != null) {
            copy = new Index(index);
        }
        return copy;
    }

    private Type deepCopy(Type type) {
        Type copy = null;
        if (type != null) {
            copy = new Type(type);
        }
        return copy;
    }

    private FieldSchema deepCopy(FieldSchema schema) {
        FieldSchema copy = null;
        if (schema != null) {
            copy = new FieldSchema(schema);
        }
        return copy;
    }

    private Function deepCopy(Function func) {
        Function copy = null;
        if (func != null) {
            copy = new Function(func);
        }
        return copy;
    }

    protected PrincipalPrivilegeSet deepCopy(PrincipalPrivilegeSet pps) {
        PrincipalPrivilegeSet copy = null;
        if (pps != null) {
            copy = new PrincipalPrivilegeSet(pps);
        }
        return copy;
    }

    private List<Partition> deepCopyPartitions(List<Partition> partitions) {
        return this.deepCopyPartitions(partitions, null);
    }

    private List<Partition> deepCopyPartitions(Collection<Partition> src, List<Partition> dest) {
        if (src == null) {
            return dest;
        }
        if (dest == null) {
            dest = new ArrayList<Partition>(src.size());
        }
        for (Partition part : src) {
            dest.add(this.deepCopy(part));
        }
        return dest;
    }

    private List<Table> deepCopyTables(List<Table> tables) {
        ArrayList<Table> copy = null;
        if (tables != null) {
            copy = new ArrayList<Table>();
            for (Table tab : tables) {
                copy.add(this.deepCopy(tab));
            }
        }
        return copy;
    }

    protected List<FieldSchema> deepCopyFieldSchemas(List<FieldSchema> schemas) {
        ArrayList<FieldSchema> copy = null;
        if (schemas != null) {
            copy = new ArrayList<FieldSchema>();
            for (FieldSchema schema : schemas) {
                copy.add(this.deepCopy(schema));
            }
        }
        return copy;
    }

    @Override
    public boolean dropIndex(String dbName, String tblName, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_index_by_name(dbName, tblName, name, deleteData);
    }

    @Override
    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        GrantRevokeRoleRequest req = new GrantRevokeRoleRequest();
        req.setRequestType(GrantRevokeType.GRANT);
        req.setRoleName(roleName);
        req.setPrincipalName(userName);
        req.setPrincipalType(principalType);
        req.setGrantor(grantor);
        req.setGrantorType(grantorType);
        req.setGrantOption(grantOption);
        GrantRevokeRoleResponse res = this.client.grant_revoke_role(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean create_role(Role role) throws MetaException, TException {
        return this.client.create_role(role);
    }

    @Override
    public boolean drop_role(String roleName) throws MetaException, TException {
        return this.client.drop_role(roleName);
    }

    @Override
    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return this.client.list_roles(principalName, principalType);
    }

    @Override
    public List<String> listRoleNames() throws MetaException, TException {
        return this.client.get_role_names();
    }

    @Override
    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest req) throws MetaException, TException {
        return this.client.get_principals_in_role(req);
    }

    @Override
    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest getRolePrincReq) throws MetaException, TException {
        return this.client.get_role_grants_for_principal(getRolePrincReq);
    }

    @Override
    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        GrantRevokePrivilegeRequest req = new GrantRevokePrivilegeRequest();
        req.setRequestType(GrantRevokeType.GRANT);
        req.setPrivileges(privileges);
        GrantRevokePrivilegeResponse res = this.client.grant_revoke_privileges(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        GrantRevokeRoleRequest req = new GrantRevokeRoleRequest();
        req.setRequestType(GrantRevokeType.REVOKE);
        req.setRoleName(roleName);
        req.setPrincipalName(userName);
        req.setPrincipalType(principalType);
        req.setGrantOption(grantOption);
        GrantRevokeRoleResponse res = this.client.grant_revoke_role(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        GrantRevokePrivilegeRequest req = new GrantRevokePrivilegeRequest();
        req.setRequestType(GrantRevokeType.REVOKE);
        req.setPrivileges(privileges);
        req.setRevokeGrantOption(grantOption);
        GrantRevokePrivilegeResponse res = this.client.grant_revoke_privileges(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    @Override
    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
        return this.client.get_privilege_set(hiveObject, userName, groupNames);
    }

    @Override
    public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws MetaException, TException {
        return this.client.list_privileges(principalName, principalType, hiveObject);
    }

    public String getDelegationToken(String renewerKerberosPrincipalName) throws MetaException, TException, IOException {
        String owner = this.conf.getUser();
        return this.getDelegationToken(owner, renewerKerberosPrincipalName);
    }

    @Override
    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        if (this.localMetaStore) {
            return null;
        }
        return this.client.get_delegation_token(owner, renewerKerberosPrincipalName);
    }

    @Override
    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            return 0L;
        }
        return this.client.renew_delegation_token(tokenStrForm);
    }

    @Override
    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            return;
        }
        this.client.cancel_delegation_token(tokenStrForm);
    }

    @Override
    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        return this.client.add_token(tokenIdentifier, delegationToken);
    }

    @Override
    public boolean removeToken(String tokenIdentifier) throws TException {
        return this.client.remove_token(tokenIdentifier);
    }

    @Override
    public String getToken(String tokenIdentifier) throws TException {
        return this.client.get_token(tokenIdentifier);
    }

    @Override
    public List<String> getAllTokenIdentifiers() throws TException {
        return this.client.get_all_token_identifiers();
    }

    @Override
    public int addMasterKey(String key) throws MetaException, TException {
        return this.client.add_master_key(key);
    }

    @Override
    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException, TException {
        this.client.update_master_key(seqNo, key);
    }

    @Override
    public boolean removeMasterKey(Integer keySeq) throws TException {
        return this.client.remove_master_key(keySeq);
    }

    @Override
    public String[] getMasterKeys() throws TException {
        List<String> keyList = this.client.get_master_keys();
        return keyList.toArray(new String[keyList.size()]);
    }

    @Override
    public ValidTxnList getValidTxns() throws TException {
        return TxnUtils.createValidReadTxnList(this.client.get_open_txns(), 0L);
    }

    @Override
    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        return TxnUtils.createValidReadTxnList(this.client.get_open_txns(), currentTxn);
    }

    @Override
    public long openTxn(String user) throws TException {
        OpenTxnsResponse txns = this.openTxns(user, 1);
        return txns.getTxn_ids().get(0);
    }

    @Override
    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
        return this.client.open_txns(new OpenTxnRequest(numTxns, user, hostname));
    }

    @Override
    public void rollbackTxn(long txnid) throws NoSuchTxnException, TException {
        this.client.abort_txn(new AbortTxnRequest(txnid));
    }

    @Override
    public void commitTxn(long txnid) throws NoSuchTxnException, TxnAbortedException, TException {
        this.client.commit_txn(new CommitTxnRequest(txnid));
    }

    @Override
    public GetOpenTxnsInfoResponse showTxns() throws TException {
        return this.client.get_open_txns_info();
    }

    @Override
    public void abortTxns(List<Long> txnids) throws NoSuchTxnException, TException {
        this.client.abort_txns(new AbortTxnsRequest(txnids));
    }

    @Override
    public LockResponse lock(LockRequest request) throws NoSuchTxnException, TxnAbortedException, TException {
        return this.client.lock(request);
    }

    @Override
    public LockResponse checkLock(long lockid) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        return this.client.check_lock(new CheckLockRequest(lockid));
    }

    @Override
    public void unlock(long lockid) throws NoSuchLockException, TxnOpenException, TException {
        this.client.unlock(new UnlockRequest(lockid));
    }

    @Override
    @Deprecated
    public ShowLocksResponse showLocks() throws TException {
        return this.client.show_locks(new ShowLocksRequest());
    }

    @Override
    public ShowLocksResponse showLocks(ShowLocksRequest request) throws TException {
        return this.client.show_locks(request);
    }

    @Override
    public void heartbeat(long txnid, long lockid) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        HeartbeatRequest hb = new HeartbeatRequest();
        hb.setLockid(lockid);
        hb.setTxnid(txnid);
        this.client.heartbeat(hb);
    }

    @Override
    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws NoSuchTxnException, TxnAbortedException, TException {
        HeartbeatTxnRangeRequest rqst = new HeartbeatTxnRangeRequest(min, max);
        return this.client.heartbeat_txn_range(rqst);
    }

    @Override
    @Deprecated
    public void compact(String dbname, String tableName, String partitionName, CompactionType type) throws TException {
        CompactionRequest cr = new CompactionRequest();
        if (dbname == null) {
            cr.setDbname("default");
        } else {
            cr.setDbname(dbname);
        }
        cr.setTablename(tableName);
        if (partitionName != null) {
            cr.setPartitionname(partitionName);
        }
        cr.setType(type);
        this.client.compact(cr);
    }

    @Override
    public void compact(String dbname, String tableName, String partitionName, CompactionType type, Map<String, String> tblproperties) throws TException {
        CompactionRequest cr = new CompactionRequest();
        if (dbname == null) {
            cr.setDbname("default");
        } else {
            cr.setDbname(dbname);
        }
        cr.setTablename(tableName);
        if (partitionName != null) {
            cr.setPartitionname(partitionName);
        }
        cr.setType(type);
        cr.setProperties(tblproperties);
        this.client.compact(cr);
    }

    @Override
    public ShowCompactResponse showCompactions() throws TException {
        return this.client.show_compact(new ShowCompactRequest());
    }

    @Override
    @Deprecated
    public void addDynamicPartitions(long txnId, String dbName, String tableName, List<String> partNames) throws TException {
        this.client.add_dynamic_partitions(new AddDynamicPartitions(txnId, dbName, tableName, partNames));
    }

    @Override
    public void addDynamicPartitions(long txnId, String dbName, String tableName, List<String> partNames, DataOperationType operationType) throws TException {
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, dbName, tableName, partNames);
        adp.setOperationType(operationType);
        this.client.add_dynamic_partitions(adp);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws TException {
        NotificationEventRequest rqst = new NotificationEventRequest(lastEventId);
        rqst.setMaxEvents(maxEvents);
        NotificationEventResponse rsp = this.client.get_next_notification(rqst);
        LOG.debug("Got back " + rsp.getEventsSize() + " events");
        if (filter == null) {
            return rsp;
        }
        NotificationEventResponse filtered = new NotificationEventResponse();
        if (rsp != null && rsp.getEvents() != null) {
            for (NotificationEvent e : rsp.getEvents()) {
                if (!filter.accept(e)) continue;
                filtered.addToEvents(e);
            }
        }
        return filtered;
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        return this.client.get_current_notificationEventId();
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public FireEventResponse fireListenerEvent(FireEventRequest rqst) throws TException {
        return this.client.fire_listener_event(rqst);
    }

    public static IMetaStoreClient newSynchronizedClient(IMetaStoreClient client) {
        return (IMetaStoreClient)Proxy.newProxyInstance(HiveMetaStoreClient.class.getClassLoader(), new Class[]{IMetaStoreClient.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    @Override
    public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, TException, NoSuchObjectException, UnknownDBException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        assert (db_name != null);
        assert (tbl_name != null);
        assert (partKVs != null);
        this.client.markPartitionForEvent(db_name, tbl_name, partKVs, eventType);
    }

    @Override
    public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, UnknownTableException, UnknownDBException, TException, InvalidPartitionException, UnknownPartitionException {
        assert (db_name != null);
        assert (tbl_name != null);
        assert (partKVs != null);
        return this.client.isPartitionMarkedForEvent(db_name, tbl_name, partKVs, eventType);
    }

    @Override
    public void createFunction(Function func) throws InvalidObjectException, MetaException, TException {
        if (func == null) {
            throw new MetaException("Function cannot be null.");
        }
        this.client.create_function(func);
    }

    @Override
    public void alterFunction(String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        this.client.alter_function(dbName, funcName, newFunction);
    }

    @Override
    public void dropFunction(String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        this.client.drop_function(dbName, funcName);
    }

    @Override
    public Function getFunction(String dbName, String funcName) throws MetaException, TException {
        Function f = this.client.get_function(dbName, funcName);
        return this.fastpath ? f : this.deepCopy(f);
    }

    @Override
    public List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        return this.client.get_functions(dbName, pattern);
    }

    @Override
    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        return this.client.get_all_functions();
    }

    protected void create_table_with_environment_context(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.client.create_table_with_environment_context(tbl, envContext);
    }

    protected void drop_table_with_environment_context(String dbname, String name, boolean deleteData, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        this.client.drop_table_with_environment_context(dbname, name, deleteData, envContext);
    }

    @Override
    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partNames) throws NoSuchObjectException, MetaException, TException {
        if (colNames.isEmpty() || partNames.isEmpty()) {
            LOG.debug("Columns is empty or partNames is empty : Short-circuiting stats eval on client side.");
            return new AggrStats(new ArrayList<ColumnStatisticsObj>(), 0L);
        }
        PartitionsStatsRequest req = new PartitionsStatsRequest(dbName, tblName, colNames, partNames);
        return this.client.get_aggr_stats_for(req);
    }

    @Override
    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(final List<Long> fileIds) throws TException {
        return new MetastoreMapIterable<Long, ByteBuffer>(){
            private int listIndex = 0;

            @Override
            protected Map<Long, ByteBuffer> fetchNextBatch() throws TException {
                if (this.listIndex == fileIds.size()) {
                    return null;
                }
                int endIndex = Math.min(this.listIndex + HiveMetaStoreClient.this.fileMetadataBatchSize, fileIds.size());
                List subList = fileIds.subList(this.listIndex, endIndex);
                GetFileMetadataResult resp = HiveMetaStoreClient.this.sendGetFileMetadataReq(subList);
                if (!resp.isIsSupported()) {
                    return null;
                }
                this.listIndex = endIndex;
                return resp.getMetadata();
            }
        };
    }

    private GetFileMetadataResult sendGetFileMetadataReq(List<Long> fileIds) throws TException {
        return this.client.get_file_metadata(new GetFileMetadataRequest(fileIds));
    }

    @Override
    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(final List<Long> fileIds, final ByteBuffer sarg, final boolean doGetFooters) throws TException {
        return new MetastoreMapIterable<Long, MetadataPpdResult>(){
            private int listIndex = 0;

            @Override
            protected Map<Long, MetadataPpdResult> fetchNextBatch() throws TException {
                if (this.listIndex == fileIds.size()) {
                    return null;
                }
                int endIndex = Math.min(this.listIndex + HiveMetaStoreClient.this.fileMetadataBatchSize, fileIds.size());
                List subList = fileIds.subList(this.listIndex, endIndex);
                GetFileMetadataByExprResult resp = HiveMetaStoreClient.this.sendGetFileMetadataBySargReq(sarg, subList, doGetFooters);
                if (!resp.isIsSupported()) {
                    return null;
                }
                this.listIndex = endIndex;
                return resp.getMetadata();
            }
        };
    }

    private GetFileMetadataByExprResult sendGetFileMetadataBySargReq(ByteBuffer sarg, List<Long> fileIds, boolean doGetFooters) throws TException {
        GetFileMetadataByExprRequest req = new GetFileMetadataByExprRequest(fileIds, sarg);
        req.setDoGetFooters(doGetFooters);
        return this.client.get_file_metadata_by_expr(req);
    }

    @Override
    public void clearFileMetadata(List<Long> fileIds) throws TException {
        ClearFileMetadataRequest req = new ClearFileMetadataRequest();
        req.setFileIds(fileIds);
        this.client.clear_file_metadata(req);
    }

    @Override
    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        PutFileMetadataRequest req = new PutFileMetadataRequest();
        req.setFileIds(fileIds);
        req.setMetadata(metadata);
        this.client.put_file_metadata(req);
    }

    @Override
    public boolean isSameConfObj(HiveConf c) {
        return this.conf == c;
    }

    @Override
    public boolean cacheFileMetadata(String dbName, String tableName, String partName, boolean allParts) throws TException {
        CacheFileMetadataRequest req = new CacheFileMetadataRequest();
        req.setDbName(dbName);
        req.setTblName(tableName);
        if (partName != null) {
            req.setPartName(partName);
        } else {
            req.setIsAllParts(allParts);
        }
        CacheFileMetadataResult result = this.client.cache_file_metadata(req);
        return result.isIsSupported();
    }

    @Override
    public String getMetastoreDbUuid() throws TException {
        return this.client.get_metastore_db_uuid();
    }

    public static abstract class MetastoreMapIterable<K, V>
    implements Iterable<Map.Entry<K, V>>,
    Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, V>> currentIter;

        protected abstract Map<K, V> fetchNextBatch() throws TException;

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            this.ensureCurrentBatch();
            return this.currentIter != null;
        }

        private void ensureCurrentBatch() {
            Map<K, V> currentBatch;
            if (this.currentIter != null && this.currentIter.hasNext()) {
                return;
            }
            this.currentIter = null;
            do {
                try {
                    currentBatch = this.fetchNextBatch();
                }
                catch (TException ex) {
                    throw new RuntimeException(ex);
                }
                if (currentBatch != null) continue;
                return;
            } while (currentBatch.isEmpty());
            this.currentIter = currentBatch.entrySet().iterator();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.ensureCurrentBatch();
            if (this.currentIter == null) {
                throw new NoSuchElementException();
            }
            return this.currentIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final IMetaStoreClient client;

        SynchronizedHandler(IMetaStoreClient client) {
            this.client = client;
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.client, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

