/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsonoutput;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputField;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputMeta;

public class JsonOutputMetaInjection
implements StepMetaInjectionInterface {
    private JsonOutputMeta meta;

    public JsonOutputMetaInjection(JsonOutputMeta meta) {
        this.meta = meta;
    }

    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] fieldsEntries;
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.OPERATION, Entry.JSON_BLOC_NAME, Entry.NR_ROWS_IN_BLOC, Entry.OUTPUT_VALUE, Entry.COMPATIBILITY_MODE, Entry.FILE_NAME, Entry.APPEND, Entry.CREATE_PARENT_FOLDER, Entry.DONT_CREATE_AT_START, Entry.EXTENSION, Entry.ENCODING, Entry.PASS_TO_SERVLET, Entry.INC_DATE_IN_FILENAME, Entry.INC_TIME_IN_FILENAME, Entry.ADD_TO_RESULT}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.JSON_FIELDS.name(), 0, Entry.JSON_FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.JSON_FIELD.name(), 0, Entry.JSON_FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : fieldsEntries = new Entry[]{Entry.JSON_FIELDNAME, Entry.JSON_ELEMENTNAME}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<String> jsonFields = new ArrayList<String>();
        ArrayList<String> jsonElements = new ArrayList<String>();
        block22: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case JSON_FIELDS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.JSON_FIELD) continue;
                        String jsonFieldname = null;
                        String jsonElement = null;
                        List entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case JSON_FIELDNAME: {
                                    jsonFieldname = value;
                                    break;
                                }
                                case JSON_ELEMENTNAME: {
                                    jsonElement = value;
                                    break;
                                }
                            }
                        }
                        jsonFields.add(jsonFieldname);
                        jsonElements.add(jsonElement);
                    }
                    continue block22;
                }
                case OPERATION: {
                    this.meta.setOperationType(JsonOutputMeta.getOperationTypeByDesc(lookValue));
                    break;
                }
                case JSON_BLOC_NAME: {
                    this.meta.setJsonBloc(lookValue);
                    break;
                }
                case NR_ROWS_IN_BLOC: {
                    this.meta.setNrRowsInBloc(lookValue);
                    break;
                }
                case OUTPUT_VALUE: {
                    this.meta.setOutputValue(lookValue);
                    break;
                }
                case COMPATIBILITY_MODE: {
                    this.meta.setCompatibilityMode("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FILE_NAME: {
                    this.meta.setFileName(lookValue);
                    break;
                }
                case APPEND: {
                    this.meta.setFileAppended("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case CREATE_PARENT_FOLDER: {
                    this.meta.setCreateParentFolder("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case DONT_CREATE_AT_START: {
                    this.meta.setDoNotOpenNewFileInit("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case EXTENSION: {
                    this.meta.setExtension(lookValue);
                    break;
                }
                case ENCODING: {
                    this.meta.setEncoding(lookValue);
                    break;
                }
                case PASS_TO_SERVLET: {
                    this.meta.setServletOutput("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case INC_DATE_IN_FILENAME: {
                    this.meta.setDateInFilename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case INC_TIME_IN_FILENAME: {
                    this.meta.setTimeInFilename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ADD_TO_RESULT: {
                    this.meta.setAddToResult("Y".equalsIgnoreCase(lookValue));
                    break;
                }
            }
        }
        if (jsonFields.size() > 0) {
            JsonOutputField[] jof = new JsonOutputField[jsonFields.size()];
            Iterator iJsonFields = jsonFields.iterator();
            Iterator iJsonElements = jsonElements.iterator();
            int i = 0;
            while (iJsonFields.hasNext()) {
                JsonOutputField field = new JsonOutputField();
                field.setFieldName((String)iJsonFields.next());
                field.setElementName((String)iJsonElements.next());
                jof[i] = field;
                ++i;
            }
            this.meta.setOutputFields(jof);
        }
    }

    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public JsonOutputMeta getMeta() {
        return this.meta;
    }

    private static enum Entry {
        OPERATION(2, "The operation to perform (Output Value, Write to File, Ouptut value and write to file)"),
        JSON_BLOC_NAME(2, "The name of the Json Bloc"),
        NR_ROWS_IN_BLOC(2, "The number of rows in a bloc"),
        OUTPUT_VALUE(2, "The field to contain the output JSON"),
        COMPATIBILITY_MODE(2, "Run in Compatibility Mode? (Y/N)"),
        FILE_NAME(2, "The output file name"),
        APPEND(2, "Append if the file exists? (Y/N)"),
        CREATE_PARENT_FOLDER(2, "Create the parent folder? (Y/N)"),
        DONT_CREATE_AT_START(2, "Do not create the file at start? (Y/N)"),
        EXTENSION(2, "The file extension"),
        ENCODING(2, "Encoding type (for allowed values see: http://wiki.pentaho.com/display/EAI/JSON+output)"),
        PASS_TO_SERVLET(2, "Pass output to servlet? (Y/N)"),
        INC_DATE_IN_FILENAME(2, "Include date in filename? (Y/N)"),
        INC_TIME_IN_FILENAME(2, "Include time in filename? (Y/N)"),
        ADD_TO_RESULT(2, "Add file to result filenames? (Y/N)"),
        JSON_FIELDS(0, "The fields to add to the JSON"),
        JSON_FIELD(0, "One field to add to the JSON"),
        JSON_FIELDNAME(2, "Stream field name"),
        JSON_ELEMENTNAME(2, "Name of the JSON element");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

