/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.client.impl;

import com.amazonaws.services.pricing.AWSPricing;
import com.amazonaws.services.pricing.model.AWSPricingException;
import com.amazonaws.services.pricing.model.Filter;
import com.amazonaws.services.pricing.model.GetProductsRequest;
import com.amazonaws.services.pricing.model.GetProductsResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pentaho.amazon.InstanceType;
import org.pentaho.amazon.client.api.PricingClient;

public class PricingClientImpl
implements PricingClient {
    private AWSPricing pricing;
    private String humanReadableRegion;
    private Collection<Filter> filters = new ArrayList<Filter>();
    private List<String> instanceTypes;
    private static final String FIELD_TYPE = "TERM_MATCH";

    public PricingClientImpl(AWSPricing pricing, String humanReadableRegion) {
        this.pricing = pricing;
        this.humanReadableRegion = humanReadableRegion;
    }

    private static Filter createProductFilter(String fieldType, String fieldName, String fieldValue) {
        Filter fieldFilter = new Filter();
        fieldFilter.setType(fieldType);
        fieldFilter.setField(fieldName);
        fieldFilter.setValue(fieldValue);
        return fieldFilter;
    }

    private void addFiltersToProductRequest() {
        this.filters.add(PricingClientImpl.createProductFilter(FIELD_TYPE, "softwareType", "EMR"));
        this.filters.add(PricingClientImpl.createProductFilter(FIELD_TYPE, "location", this.humanReadableRegion));
    }

    private GetProductsRequest initProductsRequest() {
        GetProductsRequest productsRequest = new GetProductsRequest();
        this.addFiltersToProductRequest();
        productsRequest.setServiceCode("ElasticMapReduce");
        productsRequest.setFilters(this.filters);
        return productsRequest;
    }

    private List<String> getProductDescriptions() {
        GetProductsRequest productsRequest = this.initProductsRequest();
        GetProductsResult productsResult = this.pricing.getProducts(productsRequest);
        List productDescriptions = productsResult.getPriceList();
        return productDescriptions;
    }

    @Override
    public List<String> populateInstanceTypesForSelectedRegion() throws AWSPricingException, IOException {
        List<String> productDescriptions = this.getProductDescriptions();
        if (productDescriptions == null || productDescriptions.size() == 0) {
            return this.instanceTypes;
        }
        ArrayList<InstanceType> tmpInstanceTypes = new ArrayList<InstanceType>();
        ObjectMapper mapper = new ObjectMapper();
        for (String description : productDescriptions) {
            String instanceTypeName = mapper.readTree(description).path("product").get("attributes").get("instanceType").asText();
            String instanceFamily = mapper.readTree(description).path("product").get("attributes").get("instanceFamily").asText();
            tmpInstanceTypes.add(new InstanceType(instanceTypeName, instanceFamily));
        }
        this.instanceTypes = InstanceType.sortInstanceTypes(tmpInstanceTypes);
        return this.instanceTypes;
    }
}

