/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

@InterfaceAudience.Private
public final class LogAggregationWebUtils {
    private LogAggregationWebUtils() {
    }

    public static long getLogStartIndex(HtmlBlock.Block html, String startStr) throws NumberFormatException {
        long start = -4096L;
        if (startStr != null && !startStr.isEmpty()) {
            start = Long.parseLong(startStr);
        }
        return start;
    }

    public static long getLogEndIndex(HtmlBlock.Block html, String endStr) throws NumberFormatException {
        long end = Long.MAX_VALUE;
        if (endStr != null && !endStr.isEmpty()) {
            end = Long.parseLong(endStr);
        }
        return end;
    }

    public static ContainerId verifyAndGetContainerId(HtmlBlock.Block html, String containerIdStr) {
        if (containerIdStr == null || containerIdStr.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs without a ContainerId"}))).__();
            return null;
        }
        ContainerId containerId = null;
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs for invalid containerId: " + containerIdStr}))).__();
            return null;
        }
        return containerId;
    }

    public static NodeId verifyAndGetNodeId(HtmlBlock.Block html, String nodeIdStr) {
        if (nodeIdStr == null || nodeIdStr.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs without a NodeId"}))).__();
            return null;
        }
        NodeId nodeId = null;
        try {
            nodeId = NodeId.fromString((String)nodeIdStr);
        }
        catch (IllegalArgumentException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs. Invalid nodeId: " + nodeIdStr}))).__();
            return null;
        }
        return nodeId;
    }

    public static String verifyAndGetAppOwner(HtmlBlock.Block html, String appOwner) {
        if (appOwner == null || appOwner.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Cannot get container logs without an app owner"}))).__();
        }
        return appOwner;
    }
}

