/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaverseCompletionService
implements CompletionService<String> {
    private ExecutorCompletionService<String> executionCompletionService;
    private Executor executor = Executors.newCachedThreadPool();
    private static final Logger log = LoggerFactory.getLogger(MetaverseCompletionService.class);
    private Queue<Future<String>> queue = new ConcurrentLinkedQueue<Future<String>>();

    public static MetaverseCompletionService getInstance() {
        return Holder.INSTANCE;
    }

    private MetaverseCompletionService() {
        this.executionCompletionService = new ExecutorCompletionService(this.executor);
    }

    @Override
    public Future<String> submit(Callable<String> task) {
        log.debug("Submitting Callable task --> " + task.toString());
        Future<String> f = this.executionCompletionService.submit(task);
        this.queue.add(f);
        return f;
    }

    @Override
    public Future<String> submit(Runnable task, String result) {
        log.debug("Submitting Runnable task --> " + result);
        Future<String> f = this.executionCompletionService.submit(task, result);
        this.queue.add(f);
        return f;
    }

    @Override
    public Future<String> take() throws InterruptedException {
        Future<String> result = this.executionCompletionService.take();
        this.queue.remove(result);
        return result;
    }

    @Override
    public Future<String> poll() {
        Future<String> result = this.executionCompletionService.poll();
        this.queue.remove(result);
        return result;
    }

    @Override
    public Future<String> poll(long timeout, TimeUnit unit) throws InterruptedException {
        Future<String> result = this.executionCompletionService.poll(timeout, unit);
        this.queue.remove(result);
        return result;
    }

    public void waitTillEmpty() throws InterruptedException, ExecutionException {
        while (this.queue.size() > 0) {
            Future<String> result = this.poll(200L, TimeUnit.MILLISECONDS);
            if (result == null || result.isCancelled()) continue;
            try {
                String id = result.get();
                log.debug("Process Finished --> " + id);
            }
            catch (ExecutionException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class Holder {
        private static final MetaverseCompletionService INSTANCE = new MetaverseCompletionService();

        private Holder() {
        }
    }
}

