/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.tableinput;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ConnectionExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.model.BaseDatabaseResourceInfo;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableInputStepAnalyzer
extends ConnectionExternalResourceStepAnalyzer<TableInputMeta> {
    private Logger log = LoggerFactory.getLogger(TableInputStepAnalyzer.class);

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(TableInputMeta.class);
            }
        };
    }

    protected IMetaverseNode createTableNode(IExternalResourceInfo resource) throws MetaverseAnalyzerException {
        BaseDatabaseResourceInfo resourceInfo = (BaseDatabaseResourceInfo)resource;
        Object obj = resourceInfo.getAttributes().get("query");
        String query = obj == null ? null : obj.toString();
        MetaverseComponentDescriptor componentDescriptor = new MetaverseComponentDescriptor("SQL", "SQL Query", this.getConnectionNode(), this.getDescriptor().getContext());
        IMetaverseNode tableNode = this.createNodeFromDescriptor((IComponentDescriptor)componentDescriptor);
        tableNode.setProperty("namespace", (Object)componentDescriptor.getNamespace().getNamespaceId());
        tableNode.setProperty("query", (Object)query);
        tableNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DB_QUERY);
        return tableNode;
    }

    public String getResourceInputNodeType() {
        return "Database Column";
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    protected Set<StepField> getUsedFields(TableInputMeta meta) {
        return null;
    }

    public IMetaverseNode getConnectionNode() throws MetaverseAnalyzerException {
        this.connectionNode = (IMetaverseNode)this.getConnectionAnalyzer().analyze(this.getDescriptor(), (Object)((TableInputMeta)this.baseStepMeta).getDatabaseMeta());
        return this.connectionNode;
    }

    public void setBaseStepMeta(TableInputMeta meta) {
        this.baseStepMeta = meta;
    }

    protected void customAnalyze(TableInputMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        super.customAnalyze((BaseStepMeta)meta, rootNode);
        rootNode.setProperty("query", (Object)this.parentTransMeta.environmentSubstitute(meta.getSQL()));
    }

    protected IClonableStepAnalyzer newInstance() {
        return new TableInputStepAnalyzer();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

