/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.io.IOException;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.log4j.Logger;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.common.format.S3NCredentialUtils;
import org.pentaho.hadoop.shim.common.format.orc.OrcConverter;
import org.pentaho.hadoop.shim.common.format.orc.OrcMetaDataReader;
import org.pentaho.hadoop.shim.common.format.orc.OrcSchemaConverter;

public class PentahoOrcRecordReader
implements IPentahoInputFormat.IPentahoRecordReader {
    private static final Logger logger = Logger.getLogger(PentahoOrcRecordReader.class);
    private final Configuration conf;
    private final List<? extends IOrcInputField> dialogInputFields;
    private final List<? extends IOrcInputField> orcInputFields;
    private VectorizedRowBatch batch;
    private RecordReader recordReader;
    private int currentBatchRow;
    private TypeDescription typeDescription;
    private Map<String, Integer> schemaToOrcSubcripts;
    private Path filePath;
    private FileSystem fs;
    private OrcConverter orcConverter = new OrcConverter();

    public PentahoOrcRecordReader(String fileName, Configuration conf, List<? extends IOrcInputField> dialogInputFields) {
        this.conf = conf;
        this.dialogInputFields = dialogInputFields;
        Reader reader = null;
        try {
            S3NCredentialUtils.applyS3CredentialsToHadoopConfigurationIfNecessary(fileName, conf);
            this.filePath = new Path(S3NCredentialUtils.scrubFilePathIfNecessary(fileName));
            this.fs = FileSystem.get((URI)this.filePath.toUri(), (Configuration)conf);
            if (!this.fs.exists(this.filePath)) {
                throw new NoSuchFileException(fileName);
            }
            if (this.fs.getFileStatus(this.filePath).isDirectory()) {
                PathFilter pathFilter = new PathFilter(){

                    public boolean accept(Path file) {
                        return file.getName().endsWith(".orc");
                    }
                };
                FileStatus[] fileStatuses = this.fs.listStatus(this.filePath, pathFilter);
                if (fileStatuses.length == 0) {
                    throw new NoSuchFileException(fileName);
                }
                this.filePath = fileStatuses[0].getPath();
            }
            reader = OrcFile.createReader((Path)this.filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf).filesystem(this.fs));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read data from file " + fileName, e);
        }
        try {
            this.recordReader = reader.rows();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get record reader for file " + fileName, e);
        }
        this.typeDescription = reader.getSchema();
        OrcSchemaConverter orcSchemaConverter = new OrcSchemaConverter();
        this.orcInputFields = orcSchemaConverter.buildInputFields(this.typeDescription);
        OrcMetaDataReader orcMetaDataReader = new OrcMetaDataReader(reader);
        orcMetaDataReader.read(this.orcInputFields);
        this.batch = this.typeDescription.createRowBatch();
        HashMap<String, Integer> orcColumnNumberMap = new HashMap<String, Integer>();
        int orcFieldNumber = 0;
        for (String string : this.typeDescription.getFieldNames()) {
            orcColumnNumberMap.put(string, orcFieldNumber++);
        }
        this.schemaToOrcSubcripts = new HashMap<String, Integer>();
        for (IOrcInputField iOrcInputField : dialogInputFields) {
            if (iOrcInputField == null) continue;
            Integer colNumber = (Integer)orcColumnNumberMap.get(iOrcInputField.getFormatFieldName());
            if (colNumber == null) {
                throw new IllegalArgumentException("Column " + iOrcInputField.getFormatFieldName() + " does not exist in the ORC file.  Please use the getFields button");
            }
            this.schemaToOrcSubcripts.put(iOrcInputField.getPentahoFieldName(), colNumber);
        }
        try {
            this.setNextBatch();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("No rows to read in " + fileName, e);
        }
    }

    private boolean setNextBatch() throws IOException {
        this.currentBatchRow = 0;
        return this.recordReader.nextBatch(this.batch);
    }

    public void close() throws IOException {
        this.recordReader.close();
    }

    public Iterator<RowMetaAndData> iterator() {
        return new Iterator<RowMetaAndData>(){

            @Override
            public boolean hasNext() {
                if (PentahoOrcRecordReader.this.currentBatchRow < ((PentahoOrcRecordReader)PentahoOrcRecordReader.this).batch.size) {
                    return true;
                }
                try {
                    return PentahoOrcRecordReader.this.setNextBatch();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public RowMetaAndData next() {
                RowMetaAndData rowMeta = PentahoOrcRecordReader.this.orcConverter.convertFromOrc(PentahoOrcRecordReader.this.batch, PentahoOrcRecordReader.this.currentBatchRow, PentahoOrcRecordReader.this.dialogInputFields, PentahoOrcRecordReader.this.typeDescription, PentahoOrcRecordReader.this.schemaToOrcSubcripts, PentahoOrcRecordReader.this.orcInputFields);
                PentahoOrcRecordReader.this.currentBatchRow++;
                return rowMeta;
            }
        };
    }
}

