/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.internal;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.karaf.diagnostic.core.common.TextDumpProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class EnvironmentDumpProvider
extends TextDumpProvider {
    private static final String KEY_VALUE_FORMAT = "%1$s\t: %2$s";
    private static final String INDENT_KEY_VALUE_FORMAT = "    %1$s\t: %2$s";
    private final BundleContext bundleContext;

    public EnvironmentDumpProvider(BundleContext context) {
        super("environment.txt");
        this.bundleContext = context;
    }

    @Override
    protected void writeDump(OutputStreamWriter outputStream) throws Exception {
        if (null == outputStream) {
            return;
        }
        PrintWriter outPW = new PrintWriter(outputStream);
        DateFormat dateTimeFormatInstance = DateFormat.getDateTimeInstance(0, 0, Locale.ENGLISH);
        outPW.printf(KEY_VALUE_FORMAT, "Dump timestamp", dateTimeFormatInstance.format(new Date(System.currentTimeMillis()))).println();
        outPW.println();
        this.dumpKarafInformation(outPW);
        outPW.println();
        this.dumpOSGiInformation(outPW);
        outPW.println();
        this.dumpOSInformation(outPW);
        outPW.println();
        this.dumpVMInformation(outPW, dateTimeFormatInstance);
        outPW.println();
        this.dumpThreadsInformation(outPW);
        outPW.println();
        this.dumpClassesInformation(outPW);
        outPW.println();
        this.dumpMemoryInformation(outPW);
        outPW.println();
        this.dumpGCInformation(outPW);
    }

    private void dumpKarafInformation(PrintWriter outPW) {
        outPW.printf(KEY_VALUE_FORMAT, "Karaf", System.getProperty("karaf.name", "root") + ' ' + System.getProperty("karaf.version", "")).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "home", System.getProperty("karaf.home", "")).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "base", System.getProperty("karaf.base", "")).println();
    }

    private void dumpOSGiInformation(PrintWriter outPW) {
        Bundle[] bundles;
        if (null == this.bundleContext) {
            return;
        }
        outPW.println("OSGi:");
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            if (null == bundle || !"osgi.core".equals(bundle.getSymbolicName())) continue;
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "version", bundle.getVersion()).println();
            break;
        }
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "framework", this.bundleContext.getBundle(0L).getSymbolicName() + " - " + this.bundleContext.getBundle(0L).getVersion()).println();
    }

    private void dumpOSInformation(PrintWriter outPW) {
        OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
        if (null == mxBean) {
            return;
        }
        outPW.printf(KEY_VALUE_FORMAT, "Operating System", mxBean.getName() + ' ' + mxBean.getVersion()).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "architecture", mxBean.getArch()).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "processors", mxBean.getAvailableProcessors()).println();
    }

    private void dumpVMInformation(PrintWriter outPW, DateFormat dateTimeFormatInstance) {
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        if (mxBean == null) {
            return;
        }
        outPW.printf(KEY_VALUE_FORMAT, "Instance name", mxBean.getName()).println();
        outPW.printf(KEY_VALUE_FORMAT, "Start time", dateTimeFormatInstance.format(new Date(mxBean.getStartTime()))).println();
        outPW.printf(KEY_VALUE_FORMAT, "Uptime", this.printDuration(mxBean.getUptime())).println();
        outPW.println();
        outPW.printf(KEY_VALUE_FORMAT, "Java VM", mxBean.getVmName() + " " + mxBean.getVmVersion()).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "vendor", mxBean.getVmVendor()).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "version", System.getProperty("java.version")).println();
        outPW.println();
        outPW.println("Input arguments:");
        List<String> inputArguments = mxBean.getInputArguments();
        for (String string : inputArguments) {
            if (string != null && string.contains("=")) {
                String[] stringArray = string.split("=");
                outPW.printf(INDENT_KEY_VALUE_FORMAT, stringArray[0], stringArray[1]).println();
                continue;
            }
            outPW.printf(INDENT_KEY_VALUE_FORMAT, string, "").println();
        }
        outPW.println("Classpath:");
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "boot classpath", mxBean.getBootClassPath()).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "library path", mxBean.getLibraryPath()).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "classpath", mxBean.getClassPath()).println();
        outPW.println("System properties:");
        Map<String, String> systemProperties = mxBean.getSystemProperties();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            outPW.printf(INDENT_KEY_VALUE_FORMAT, entry.getKey(), entry.getValue()).println();
        }
        outPW.println();
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean != null) {
            outPW.printf(KEY_VALUE_FORMAT, "JIT compiler", compilationMXBean.getName()).println();
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "total compile time", this.printDuration(compilationMXBean.getTotalCompilationTime())).println();
        }
    }

    private void dumpThreadsInformation(PrintWriter outPW) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        if (null == mxBean) {
            return;
        }
        outPW.println("Threads:");
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "live", this.formatLong(mxBean.getThreadCount())).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "daemon", this.formatLong(mxBean.getDaemonThreadCount())).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "peak", this.formatLong(mxBean.getPeakThreadCount())).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "total", this.formatLong(mxBean.getTotalStartedThreadCount())).println();
    }

    private void dumpClassesInformation(PrintWriter outPW) {
        ClassLoadingMXBean mxBean = ManagementFactory.getClassLoadingMXBean();
        if (null == mxBean) {
            return;
        }
        outPW.println("Classes:");
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "loaded", this.formatLong(mxBean.getLoadedClassCount())).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "total", this.formatLong(mxBean.getTotalLoadedClassCount())).println();
        outPW.printf(INDENT_KEY_VALUE_FORMAT, "unloaded", this.formatLong(mxBean.getUnloadedClassCount())).println();
    }

    private void dumpMemoryInformation(PrintWriter outPW) {
        MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
        if (null == mxBean) {
            return;
        }
        MemoryUsage heapMemoryUsage = mxBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = mxBean.getNonHeapMemoryUsage();
        if (heapMemoryUsage != null) {
            outPW.println("HEAP Memory:");
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "commited", this.printMemory(heapMemoryUsage.getCommitted())).println();
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "init", this.printMemory(heapMemoryUsage.getInit())).println();
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "used", this.printMemory(heapMemoryUsage.getUsed())).println();
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "maximal", this.printMemory(heapMemoryUsage.getMax())).println();
        }
        if (nonHeapMemoryUsage != null) {
            outPW.println("NON-HEAP Memory:");
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "commited", this.printMemory(nonHeapMemoryUsage.getCommitted())).println();
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "init", this.printMemory(nonHeapMemoryUsage.getInit())).println();
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "used", this.printMemory(nonHeapMemoryUsage.getUsed())).println();
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "maximal", this.printMemory(nonHeapMemoryUsage.getMax())).println();
        }
    }

    private void dumpGCInformation(PrintWriter outPW) {
        List<GarbageCollectorMXBean> mxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        if (null == mxBeans || mxBeans.isEmpty()) {
            return;
        }
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        if (memoryMxBean != null) {
            outPW.printf(INDENT_KEY_VALUE_FORMAT, "pending objects", this.formatLong(memoryMxBean.getObjectPendingFinalizationCount())).println();
        }
        String gcFormat = "'%1$s' collections: %2$s\ttime: %3$s";
        outPW.println();
        for (GarbageCollectorMXBean mxBean : mxBeans) {
            if (null == mxBean) continue;
            outPW.printf(KEY_VALUE_FORMAT, "Garbage Collectors", String.format("'%1$s' collections: %2$s\ttime: %3$s", mxBean.getName(), this.formatLong(mxBean.getCollectionCount()), this.printDuration(mxBean.getCollectionTime()))).println();
        }
    }

    private String formatLong(long longValue) {
        DecimalFormat fmtI = new DecimalFormat("###,###", new DecimalFormatSymbols(Locale.ENGLISH));
        return fmtI.format(longValue);
    }

    private String printMemory(long bytes) {
        if (bytes <= 1024L) {
            return this.formatLong(bytes) + " bytes";
        }
        return this.formatLong(bytes / 1024L) + " kbytes";
    }

    private String printDuration(double uptime) {
        if ((uptime /= 1000.0) < 60.0) {
            DecimalFormat fmtD = new DecimalFormat("###,##0.000", new DecimalFormatSymbols(Locale.ENGLISH));
            return fmtD.format(uptime) + " seconds";
        }
        if ((uptime /= 60.0) < 60.0) {
            long minutes = (long)uptime;
            String s = this.formatLong(minutes) + (minutes > 1L ? " minutes" : " minute");
            return s;
        }
        if ((uptime /= 60.0) < 24.0) {
            long hours = (long)uptime;
            long minutes = (long)((uptime - (double)hours) * 60.0);
            String s = this.formatLong(hours) + (hours > 1L ? " hours" : " hour");
            if (minutes != 0L) {
                s = s + " " + this.formatLong(minutes) + (minutes > 1L ? " minutes" : " minute");
            }
            return s;
        }
        long days = (long)(uptime /= 24.0);
        long hours = (long)((uptime - (double)days) * 24.0);
        String s = this.formatLong(days) + (days > 1L ? " days" : " day");
        if (hours != 0L) {
            s = s + " " + this.formatLong(hours) + (hours > 1L ? " hours" : " hour");
        }
        return s;
    }
}

