/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util.password;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class CredentialProviderHelper {
    public static final Log LOG = LogFactory.getLog((String)CredentialProviderHelper.class.getName());
    private static Class<?> clsCredProvider;
    private static Class<?> clsCredProviderFactory;
    private static Method methGetPassword;
    private static Method methGetProviders;
    private static Method methCreateCredEntry;
    private static Method methFlush;
    public static final String SCHEME_NAME = "jceks";
    public static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";
    public static final String CREDENTIAL_PROVIDER_PASSWORD_FILE = "hadoop.security.credstore.java-keystore-provider.password-file";

    public static boolean isProviderAvailable() {
        return clsCredProvider != null && clsCredProviderFactory != null && methCreateCredEntry != null && methGetPassword != null && methFlush != null;
    }

    public static String resolveAlias(Configuration conf, String alias) throws IOException {
        LOG.debug((Object)("Resolving alias with credential provider path set to " + conf.get(CREDENTIAL_PROVIDER_PATH)));
        try {
            char[] cred = (char[])methGetPassword.invoke((Object)conf, alias);
            if (cred == null) {
                throw new IOException("The provided alias cannot be resolved");
            }
            String pass = new String(cred);
            return pass;
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Error resolving password  from the credential providers ", ite.getTargetException());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Error invoking the credential provider method", iae);
        }
    }

    public static void createCredentialEntry(Configuration conf, String alias, String credential) throws IOException {
        if (!CredentialProviderHelper.isProviderAvailable()) {
            throw new RuntimeException("CredentialProvider facility not available in the hadoop environment");
        }
        try {
            List result = (List)methGetProviders.invoke(null, conf);
            Object provider = result.get(0);
            LOG.debug((Object)("Using credential provider " + provider));
            methCreateCredEntry.invoke(provider, alias, credential.toCharArray());
            methFlush.invoke(provider, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Error creating credential entry  using the credentail provider", ite.getTargetException());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Error accessing the credential create method", iae);
        }
    }

    static {
        try {
            LOG.debug((Object)"Reflecting credential provider classes and methods");
            clsCredProvider = Class.forName("org.apache.hadoop.security.alias.CredentialProvider");
            LOG.debug((Object)"Found org.apache.hadoop.security.alias.CredentialProvider");
            clsCredProviderFactory = Class.forName("org.apache.hadoop.security.alias.CredentialProviderFactory");
            LOG.debug((Object)"Found org.apache.hadoop.security.alias.CredentialProviderFactory");
            methCreateCredEntry = clsCredProvider.getMethod("createCredentialEntry", String.class, char[].class);
            LOG.debug((Object)"Found CredentialProvider#createCredentialEntry");
            methFlush = clsCredProvider.getMethod("flush", new Class[0]);
            LOG.debug((Object)"Found CredentialProvider#flush");
            methGetPassword = Configuration.class.getMethod("getPassword", String.class);
            LOG.debug((Object)"Found Configuration#getPassword");
            methGetProviders = clsCredProviderFactory.getMethod("getProviders", Configuration.class);
            LOG.debug((Object)"Found CredentialProviderFactory#getProviders");
        }
        catch (ClassNotFoundException cnfe) {
            LOG.debug((Object)"Ignoring exception", (Throwable)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            LOG.debug((Object)"Ignoring exception", (Throwable)nsme);
        }
    }
}

