/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.util.AsyncSink;

public class LoggingAsyncSink
extends AsyncSink {
    public static final Log LOG = LogFactory.getLog((String)LoggingAsyncSink.class.getName());
    private Log contextLog;
    private Thread child;

    public LoggingAsyncSink(Log context) {
        this.contextLog = null == context ? LOG : context;
    }

    @Override
    public void processStream(InputStream is) {
        this.child = new LoggingThread(is);
        this.child.start();
    }

    @Override
    public int join() throws InterruptedException {
        this.child.join();
        return 0;
    }

    private class LoggingThread
    extends Thread {
        private InputStream stream;

        LoggingThread(InputStream is) {
            this.stream = is;
        }

        @Override
        public void run() {
            InputStreamReader isr = new InputStreamReader(this.stream);
            BufferedReader r = new BufferedReader(isr);
            try {
                String line;
                while (null != (line = r.readLine())) {
                    LoggingAsyncSink.this.contextLog.info((Object)line);
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)("IOException reading from stream: " + ioe.toString()));
            }
            try {
                r.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Error closing stream in LoggingAsyncSink: " + ioe.toString()));
            }
        }
    }
}

