/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public final class FileSystemUtil {
    private FileSystemUtil() {
    }

    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (null == path) {
            return null;
        }
        return path.getFileSystem(conf).makeQualified(path);
    }

    public static boolean isFile(Path path, Configuration conf) throws IOException {
        return path.getFileSystem(conf).isFile(path);
    }

    public static List<Path> listFiles(Path path, Configuration conf) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        FileSystem fileSystem = path.getFileSystem(conf);
        RemoteIterator files = fileSystem.listFiles(path, false);
        while (files.hasNext()) {
            result.add(((LocatedFileStatus)files.next()).getPath());
        }
        return result;
    }

    public static List<Path> findFilesWithPathContainingPattern(Path path, Configuration conf, String pattern) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        List<Path> filePaths = FileSystemUtil.listFiles(path, conf);
        for (Path filePath : filePaths) {
            if (!filePath.toString().contains(pattern)) continue;
            result.add(filePath);
        }
        return result;
    }
}

