/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.tool.ImportTool;
import org.apache.sqoop.util.ImportException;

public class ImportAllTablesTool
extends ImportTool {
    public static final Log LOG = LogFactory.getLog((String)ImportAllTablesTool.class.getName());

    public ImportAllTablesTool() {
        super("import-all-tables", true);
    }

    @Override
    protected RelatedOptions getImportOptions() {
        RelatedOptions importOpts = super.getImportOptions();
        OptionBuilder.withArgName((String)"tables");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Tables to exclude when importing all tables");
        OptionBuilder.withLongOpt((String)"exclude-tables");
        importOpts.addOption(OptionBuilder.create());
        return importOpts;
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        super.applyOptions(in, out);
        if (in.hasOption("exclude-tables")) {
            out.setAllTablesExclude(in.getOptionValue("exclude-tables"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(SqoopOptions options) {
        HashSet<String> excludes = new HashSet<String>();
        if (!this.init(options)) {
            return 1;
        }
        try {
            String[] tables;
            if (options.getAllTablesExclude() != null) {
                excludes.addAll(Arrays.asList(options.getAllTablesExclude().split(",")));
            }
            if (null == (tables = this.manager.listTables())) {
                System.err.println("Could not retrieve tables list from server");
                LOG.error((Object)"manager.listTables() returned null");
                int n = 1;
                return n;
            }
            for (String tableName : tables) {
                if (excludes.contains(tableName)) {
                    System.out.println("Skipping table: " + tableName);
                    continue;
                }
                SqoopOptions clonedOptions = (SqoopOptions)options.clone();
                clonedOptions.setTableName(tableName);
                this.importTable(clonedOptions);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)("Encountered IOException running import job: " + ioe.toString()));
            this.rethrowIfRequired(options, ioe);
            int n = 1;
            return n;
        }
        catch (ImportException ie) {
            LOG.error((Object)("Error during import: " + ie.toString()));
            this.rethrowIfRequired(options, ie);
            int n = 1;
            return n;
        }
        finally {
            this.destroy(options);
        }
        return 0;
    }
}

