/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.orm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.orm.ClassWriter;

public class TableClassName {
    public static final Log LOG = LogFactory.getLog((String)TableClassName.class.getName());
    public static final String QUERY_RESULT = "QueryResult";
    private final SqoopOptions options;

    public TableClassName(SqoopOptions opts) {
        if (null == opts) {
            throw new NullPointerException("Cannot instantiate a TableClassName on null options.");
        }
        this.options = opts;
    }

    public String getPackageForTable() {
        String predefinedClass = this.options.getClassName();
        if (null != predefinedClass) {
            int lastDot = predefinedClass.lastIndexOf(46);
            if (-1 == lastDot) {
                return null;
            }
            return predefinedClass.substring(0, lastDot);
        }
        return this.options.getPackageName();
    }

    public String getClassForTable(String tableName) {
        String packageName;
        String predefinedClass = this.options.getClassName();
        if (predefinedClass != null) {
            return predefinedClass;
        }
        String queryName = tableName;
        if (null == queryName) {
            queryName = QUERY_RESULT;
        }
        if (null != (packageName = this.options.getPackageName())) {
            return packageName + "." + queryName;
        }
        return ClassWriter.toJavaIdentifier(queryName);
    }

    public String getShortClassForTable(String tableName) {
        String fullClass = this.getClassForTable(tableName);
        if (null == fullClass) {
            return null;
        }
        int lastDot = fullClass.lastIndexOf(46);
        if (-1 == lastDot) {
            return fullClass;
        }
        return fullClass.substring(lastDot + 1, fullClass.length());
    }
}

