/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.metastore;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.metastore.GenericJobStorage;

public class AutoGenericJobStorage
extends GenericJobStorage {
    public static final Log LOG = LogFactory.getLog((String)AutoGenericJobStorage.class.getName());
    public static final String AUTO_STORAGE_IS_ACTIVE_KEY = "sqoop.metastore.client.enable.autoconnect";
    public static final String AUTO_STORAGE_CONNECT_STRING_KEY = "sqoop.metastore.client.autoconnect.url";
    public static final String AUTO_STORAGE_USER_KEY = "sqoop.metastore.client.autoconnect.username";
    private static final String DEFAULT_AUTO_USER = "SA";
    public static final String AUTO_STORAGE_PASS_KEY = "sqoop.metastore.client.autoconnect.password";
    public static final String DEFAULT_AUTO_PASSWORD = "";

    @Override
    public boolean canAccept(Map<String, String> descriptor) {
        Configuration conf = this.getConf();
        return conf.getBoolean(AUTO_STORAGE_IS_ACTIVE_KEY, true);
    }

    private String getHomeDirFileConnectStr() {
        String homeDir = System.getProperty("user.home");
        File homeDirObj = new File(homeDir);
        File sqoopDataDirObj = new File(homeDirObj, ".sqoop");
        File databaseFileObj = new File(sqoopDataDirObj, "metastore.db");
        String dbFileStr = databaseFileObj.toString();
        return "jdbc:hsqldb:file:" + dbFileStr + ";hsqldb.write_delay=false;shutdown=true";
    }

    @Override
    protected void setConnectionParameters(Map<String, String> descriptor) {
        Configuration conf = this.getConf();
        this.setMetastoreConnectStr(conf.get(AUTO_STORAGE_CONNECT_STRING_KEY, this.getHomeDirFileConnectStr()));
        this.setMetastoreUser(conf.get(AUTO_STORAGE_USER_KEY, DEFAULT_AUTO_USER));
        this.setMetastorePassword(conf.get(AUTO_STORAGE_PASS_KEY, DEFAULT_AUTO_PASSWORD));
    }
}

