/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.parquet.hadoop;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.lib.LargeObjectLoader;
import org.apache.sqoop.mapreduce.ParquetImportMapper;

public class HadoopParquetImportMapper
extends ParquetImportMapper<NullWritable, GenericRecord> {
    private static final Log LOG = LogFactory.getLog((String)HadoopParquetImportMapper.class.getName());
    private static final String HADOOP_PARQUET_AVRO_SCHEMA_KEY = "parquet.avro.schema";

    @Override
    protected LargeObjectLoader createLobLoader(Mapper.Context context) throws IOException, InterruptedException {
        return new LargeObjectLoader(context.getConfiguration(), FileOutputFormat.getWorkOutputPath((TaskInputOutputContext)context));
    }

    @Override
    protected Schema getAvroSchema(Configuration configuration) {
        String schemaString = configuration.get(HADOOP_PARQUET_AVRO_SCHEMA_KEY);
        LOG.debug((Object)("Found Avro schema: " + schemaString));
        return AvroUtil.parseAvroSchema(schemaString);
    }

    @Override
    protected void write(Mapper.Context context, GenericRecord record) throws IOException, InterruptedException {
        context.write(null, (Object)record);
    }
}

