/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.derby.security.SystemPermission;

public class DerbyPolicy
extends Policy {
    private static PermissionCollection perms;

    public DerbyPolicy() {
        if (perms == null) {
            perms = new DerbyPermissionCollection();
            this.addPermissions();
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        return perms;
    }

    private void addPermissions() {
        SystemPermission systemPermission = new SystemPermission("engine", "usederbyinternals");
        perms.add((Permission)systemPermission);
    }

    class DerbyPermissionCollection
    extends PermissionCollection {
        List<Permission> perms = new ArrayList<Permission>();

        DerbyPermissionCollection() {
        }

        @Override
        public void add(Permission p) {
            this.perms.add(p);
        }

        @Override
        public boolean implies(Permission p) {
            for (Permission perm : this.perms) {
                if (!perm.implies(p)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.enumeration(this.perms);
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }
}

