/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.lib.LargeObjectLoader;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.AutoProgressMapper;

public abstract class ParquetImportMapper<KEYOUT, VALOUT>
extends AutoProgressMapper<LongWritable, SqoopRecord, KEYOUT, VALOUT> {
    private Schema schema = null;
    private boolean bigDecimalFormatString = true;
    private LargeObjectLoader lobLoader = null;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.schema = this.getAvroSchema(conf);
        this.bigDecimalFormatString = conf.getBoolean("sqoop.bigdecimal.format.string", true);
        this.lobLoader = this.createLobLoader(context);
    }

    protected void map(LongWritable key, SqoopRecord val, Mapper.Context context) throws IOException, InterruptedException {
        try {
            val.loadLargeObjects(this.lobLoader);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        GenericRecord record = AvroUtil.toGenericRecord(val.getFieldMap(), this.schema, this.bigDecimalFormatString);
        this.write(context, record);
    }

    protected void cleanup(Mapper.Context context) throws IOException {
        if (null != this.lobLoader) {
            this.lobLoader.close();
        }
    }

    protected abstract LargeObjectLoader createLobLoader(Mapper.Context var1) throws IOException, InterruptedException;

    protected abstract Schema getAvroSchema(Configuration var1);

    protected abstract void write(Mapper.Context var1, GenericRecord var2) throws IOException, InterruptedException;
}

