/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.manager.ExportJobContext;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.ExportJobBase;
import org.apache.sqoop.mapreduce.MySQLRecordExportMapper;
import org.apache.sqoop.mapreduce.MySQLTextExportMapper;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.DataDrivenDBInputFormat;

public class MySQLExportJob
extends ExportJobBase {
    public static final Log LOG = LogFactory.getLog((String)MySQLExportJob.class.getName());

    public MySQLExportJob(ExportJobContext context) {
        super(context, null, null, NullOutputFormat.class);
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
        Configuration conf = job.getConfiguration();
        conf.setInt("sqoop.output.field.delim", (int)this.options.getOutputFieldDelim());
        conf.setInt("sqoop.output.record.delim", (int)this.options.getOutputRecordDelim());
        conf.setInt("sqoop.output.enclosed.by", (int)this.options.getOutputEnclosedBy());
        conf.setInt("sqoop.output.escaped.by", (int)this.options.getOutputEscapedBy());
        conf.setBoolean("sqoop.output.enclose.required", this.options.isOutputEncloseRequired());
        String[] extraArgs = this.options.getExtraArgs();
        if (null != extraArgs) {
            conf.setStrings("sqoop.mysql.extra.args", extraArgs);
        }
        ConnManager mgr = this.context.getConnManager();
        String username = this.options.getUsername();
        if (null == username || username.length() == 0) {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), this.options.getConnectionParams());
        } else {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword(), this.options.getConnectionParams());
        }
        String[] colNames = this.options.getColumns();
        if (null == colNames) {
            colNames = mgr.getColumnNames(tableName);
        }
        String[] sqlColNames = null;
        if (null != colNames) {
            sqlColNames = new String[colNames.length];
            for (int i = 0; i < colNames.length; ++i) {
                sqlColNames[i] = mgr.escapeColName(colNames[i]);
            }
        }
        DataDrivenDBInputFormat.setInput(job, DBWritable.class, tableName, null, null, sqlColNames);
        super.configureInputFormat(job, tableName, tableClassName, splitByCol);
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        if (this.inputIsSequenceFiles()) {
            return MySQLRecordExportMapper.class;
        }
        return MySQLTextExportMapper.class;
    }
}

