/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.manager.ExportJobContext;
import org.apache.sqoop.mapreduce.AvroExportMapper;
import org.apache.sqoop.mapreduce.AvroInputFormat;
import org.apache.sqoop.mapreduce.ExportJobBase;
import org.apache.sqoop.mapreduce.SequenceFileExportMapper;
import org.apache.sqoop.mapreduce.TextExportMapper;
import org.apache.sqoop.mapreduce.UpdateOutputFormat;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.DBOutputFormat;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;
import org.apache.sqoop.mapreduce.parquet.ParquetExportJobConfigurator;

public class JdbcUpdateExportJob
extends ExportJobBase {
    private ExportJobBase.FileType fileType;
    public static final Log LOG = LogFactory.getLog((String)JdbcUpdateExportJob.class.getName());
    private ParquetExportJobConfigurator parquetExportJobConfigurator;

    private static Class<? extends OutputFormat> getUpdateOutputFormat() throws IOException {
        return UpdateOutputFormat.class;
    }

    public JdbcUpdateExportJob(ExportJobContext context, ParquetExportJobConfigurator parquetExportJobConfigurator) throws IOException {
        super(context, null, null, JdbcUpdateExportJob.getUpdateOutputFormat());
        this.parquetExportJobConfigurator = parquetExportJobConfigurator;
    }

    public JdbcUpdateExportJob(ExportJobContext ctxt, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass, ParquetExportJobConfigurator parquetExportJobConfigurator) {
        super(ctxt, mapperClass, inputFormatClass, outputFormatClass);
        this.parquetExportJobConfigurator = parquetExportJobConfigurator;
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        if (this.isHCatJob) {
            return SqoopHCatUtilities.getExportMapperClass();
        }
        switch (this.fileType) {
            case SEQUENCE_FILE: {
                return SequenceFileExportMapper.class;
            }
            case AVRO_DATA_FILE: {
                return AvroExportMapper.class;
            }
            case PARQUET_FILE: {
                return this.parquetExportJobConfigurator.getMapperClass();
            }
        }
        return TextExportMapper.class;
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws IOException {
        ConnManager mgr = this.context.getConnManager();
        try {
            String username = this.options.getUsername();
            if (null == username || username.length() == 0) {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), this.options.getConnectionParams());
            } else {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword(), this.options.getConnectionParams());
            }
            String[] colNames = this.options.getColumns();
            if (null == colNames) {
                colNames = mgr.getColumnNames(tableName);
            }
            if (null == colNames) {
                throw new IOException("Export column names could not be determined for " + tableName);
            }
            String updateKeyColumns = this.options.getUpdateKeyCol();
            if (null == updateKeyColumns) {
                throw new IOException("Update key column not set in export job");
            }
            LinkedHashSet<String> updateKeys = new LinkedHashSet<String>();
            HashSet<String> updateKeysUppercase = new HashSet<String>();
            StringTokenizer stok = new StringTokenizer(updateKeyColumns, ",");
            while (stok.hasMoreTokens()) {
                String nextUpdateKey = stok.nextToken().trim();
                if (nextUpdateKey.length() > 0) {
                    updateKeys.add(nextUpdateKey);
                    updateKeysUppercase.add(nextUpdateKey.toUpperCase());
                    continue;
                }
                throw new RuntimeException("Invalid update key column value specified: '" + updateKeyColumns + "'");
            }
            if (updateKeys.size() == 0) {
                throw new IOException("Update key columns not valid in export job");
            }
            String[] outColNames = new String[colNames.length - updateKeys.size()];
            int j = 0;
            for (int i = 0; i < colNames.length; ++i) {
                if (updateKeysUppercase.contains(colNames[i].toUpperCase())) continue;
                outColNames[j++] = colNames[i];
            }
            DBOutputFormat.setOutput(job, mgr.escapeTableName(tableName), mgr.escapeColNames(outColNames));
            job.setOutputFormatClass(this.getOutputFormatClass());
            job.getConfiguration().set("sqoop.mapreduce.export.table.class", tableClassName);
            job.getConfiguration().set("sqoop.mapreduce.export.update.col", updateKeyColumns);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not load OutputFormat", cnfe);
        }
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
        this.fileType = this.getInputFileType();
        super.configureInputFormat(job, tableName, tableClassName, splitByCol);
        if (this.isHCatJob) {
            SqoopHCatUtilities.configureExportInputFormat(this.options, job, this.context.getConnManager(), tableName, job.getConfiguration());
            return;
        }
        if (this.fileType == ExportJobBase.FileType.AVRO_DATA_FILE) {
            LOG.debug((Object)"Configuring for Avro export");
            this.configureGenericRecordExportInputFormat(job, tableName);
        } else if (this.fileType == ExportJobBase.FileType.PARQUET_FILE) {
            LOG.debug((Object)"Configuring for Parquet export");
            this.configureGenericRecordExportInputFormat(job, tableName);
            this.parquetExportJobConfigurator.configureInputFormat(job, this.getInputPath());
        }
    }

    private void configureGenericRecordExportInputFormat(Job job, String tableName) throws IOException {
        ConnManager connManager = this.context.getConnManager();
        Map<String, Integer> columnTypeInts = this.options.getCall() == null ? connManager.getColumnTypes(tableName, this.options.getSqlQuery()) : connManager.getColumnTypesForProcedure(this.options.getCall());
        MapWritable columnTypes = new MapWritable();
        for (Map.Entry<String, Integer> e : columnTypeInts.entrySet()) {
            Text columnName = new Text(e.getKey());
            Text columnText = new Text(connManager.toJavaType(tableName, e.getKey(), e.getValue()));
            columnTypes.put((Writable)columnName, (Writable)columnText);
        }
        DefaultStringifier.store((Configuration)job.getConfiguration(), (Object)columnTypes, (String)"sqoop.avro.column.types.map");
    }

    @Override
    protected Class<? extends InputFormat> getInputFormatClass() throws ClassNotFoundException {
        if (this.isHCatJob) {
            return SqoopHCatUtilities.getInputFormatClass();
        }
        switch (this.fileType) {
            case AVRO_DATA_FILE: {
                return AvroInputFormat.class;
            }
            case PARQUET_FILE: {
                return this.parquetExportJobConfigurator.getInputFormatClass();
            }
        }
        return super.getInputFormatClass();
    }
}

