/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.manager.ExportJobContext;
import org.apache.sqoop.mapreduce.ExportBatchOutputFormat;
import org.apache.sqoop.mapreduce.ExportInputFormat;
import org.apache.sqoop.mapreduce.ExportOutputFormat;
import org.apache.sqoop.mapreduce.JobBase;
import org.apache.sqoop.mapreduce.PublishJobData;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;
import org.apache.sqoop.orm.TableClassName;
import org.apache.sqoop.util.ExportException;
import org.apache.sqoop.util.FileSystemUtil;
import org.apache.sqoop.util.LoggingUtils;
import org.apache.sqoop.util.PerfCounters;
import org.apache.sqoop.validation.ValidationContext;
import org.apache.sqoop.validation.ValidationException;

public class ExportJobBase
extends JobBase {
    public static final Log LOG = LogFactory.getLog((String)ExportJobBase.class.getName());
    public static final String SQOOP_EXPORT_TABLE_CLASS_KEY = "sqoop.mapreduce.export.table.class";
    public static final String SQOOP_EXPORT_UPDATE_COL_KEY = "sqoop.mapreduce.export.update.col";
    public static final String EXPORT_MAP_TASKS_KEY = "sqoop.mapreduce.export.map.tasks";
    public static final String SQOOP_EXPORT_MAP_TASK_MAX_ATTEMTPS = "sqoop.export.mapred.map.max.attempts";
    private long startTime;
    public static final String OPERATION = "export";
    protected ExportJobContext context;

    public ExportJobBase(ExportJobContext ctxt) {
        this(ctxt, null, null, null);
    }

    public ExportJobBase(ExportJobContext ctxt, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass) {
        super(ctxt.getOptions(), mapperClass, inputFormatClass, outputFormatClass);
        this.context = ctxt;
        this.startTime = new Date().getTime();
    }

    public static boolean isSequenceFiles(Configuration conf, Path p) throws IOException {
        return ExportJobBase.getFileType(conf, p) == FileType.SEQUENCE_FILE;
    }

    public static FileType getFileType(Configuration conf, Path p) throws IOException {
        FileSystem fs = p.getFileSystem(conf);
        try {
            FileStatus[] fileStatuses = fs.globStatus(p);
            if (null == fileStatuses) {
                LOG.warn((Object)("Input path " + p + " does not exist"));
                return FileType.UNKNOWN;
            }
            if (fileStatuses.length == 0) {
                LOG.warn((Object)("Input path " + p + " does not match any file"));
                return FileType.UNKNOWN;
            }
            FileStatus stat = fileStatuses[0];
            if (stat.isDir()) {
                Path dir = stat.getPath();
                FileStatus[] subitems = fs.listStatus(dir);
                if (subitems == null || subitems.length == 0) {
                    LOG.warn((Object)("Input path " + dir + " contains no files"));
                    return FileType.UNKNOWN;
                }
                boolean foundChild = false;
                for (int i = 0; i < subitems.length; ++i) {
                    stat = subitems[i];
                    if (stat.isDir() || stat.getPath().getName().startsWith("_")) continue;
                    foundChild = true;
                    break;
                }
                if (!foundChild) {
                    stat = null;
                }
            }
            if (null == stat) {
                LOG.warn((Object)"null FileStatus object in isSequenceFiles(); assuming false.");
                return FileType.UNKNOWN;
            }
            Path target = stat.getPath();
            return ExportJobBase.fromMagicNumber(target, conf);
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn((Object)("Input path " + p + " does not exist"));
            return FileType.UNKNOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileType fromMagicNumber(Path file, Configuration conf) {
        byte[] header = new byte[3];
        FSDataInputStream is = null;
        try {
            FileSystem fs = file.getFileSystem(conf);
            is = fs.open(file);
            is.readFully(header);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("IOException checking input file header: " + ioe));
            FileType fileType = FileType.UNKNOWN;
            return fileType;
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)("IOException closing input stream: " + ioe + "; ignoring."));
            }
        }
        if (header[0] == 83 && header[1] == 69 && header[2] == 81) {
            return FileType.SEQUENCE_FILE;
        }
        if (header[0] == 79 && header[1] == 98 && header[2] == 106) {
            return FileType.AVRO_DATA_FILE;
        }
        if (header[0] == 80 && header[1] == 65 && header[2] == 82) {
            return FileType.PARQUET_FILE;
        }
        return FileType.UNKNOWN;
    }

    protected Path getInputPath() throws IOException {
        if (this.isHCatJob) {
            return null;
        }
        Path inputPath = new Path(this.context.getOptions().getExportDir());
        Configuration conf = this.options.getConf();
        inputPath = FileSystemUtil.makeQualified(inputPath, conf);
        return inputPath;
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
        super.configureInputFormat(job, tableName, tableClassName, splitByCol);
        if (!this.isHCatJob) {
            FileInputFormat.addInputPath((Job)job, (Path)this.getInputPath());
        }
    }

    @Override
    protected Class<? extends InputFormat> getInputFormatClass() throws ClassNotFoundException {
        Class<? extends InputFormat> configuredIF = super.getInputFormatClass();
        if (null == configuredIF) {
            return ExportInputFormat.class;
        }
        return configuredIF;
    }

    @Override
    protected Class<? extends OutputFormat> getOutputFormatClass() throws ClassNotFoundException {
        Class<? extends OutputFormat> configuredOF = super.getOutputFormatClass();
        if (null == configuredOF) {
            if (!this.options.isBatchMode()) {
                return ExportOutputFormat.class;
            }
            return ExportBatchOutputFormat.class;
        }
        return configuredOF;
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        job.setMapperClass(this.getMapperClass());
        ConfigurationHelper.setJobMapSpeculativeExecution(job, false);
        job.setMapOutputKeyClass(SqoopRecord.class);
        job.setMapOutputValueClass(NullWritable.class);
    }

    @Override
    protected int configureNumMapTasks(Job job) throws IOException {
        int numMaps = super.configureNumMapTasks(job);
        job.getConfiguration().setInt(EXPORT_MAP_TASKS_KEY, numMaps);
        return numMaps;
    }

    @Override
    protected boolean runJob(Job job) throws ClassNotFoundException, IOException, InterruptedException {
        PerfCounters perfCounters = new PerfCounters();
        perfCounters.startClock();
        boolean success = this.doSubmitJob(job);
        perfCounters.stopClock();
        Counters jobCounters = job.getCounters();
        if (null == jobCounters) {
            this.displayRetiredJobNotice(LOG);
        } else {
            perfCounters.addBytes(((CounterGroup)jobCounters.getGroup("FileSystemCounters")).findCounter("HDFS_BYTES_READ").getValue());
            LOG.info((Object)("Transferred " + perfCounters.toString()));
            long numRecords = ConfigurationHelper.getNumMapInputRecords(job);
            LOG.info((Object)("Exported " + numRecords + " records."));
        }
        return success;
    }

    protected boolean doSubmitJob(Job job) throws IOException, InterruptedException, ClassNotFoundException {
        return job.waitForCompletion(true);
    }

    public void runExport() throws ExportException, IOException {
        ConnManager cmgr = this.context.getConnManager();
        SqoopOptions options = this.context.getOptions();
        Configuration conf = options.getConf();
        String outputTableName = this.context.getTableName();
        String stagingTableName = this.context.getOptions().getStagingTableName();
        String tableName = outputTableName;
        boolean stagingEnabled = false;
        if (this.isHCatJob && options.isDirect() && !this.context.getConnManager().isDirectModeHCatSupported()) {
            throw new IOException("Direct import is not compatible with HCatalog operations using the connection manager " + this.context.getConnManager().getClass().getName() + ". Please remove the parameter --direct");
        }
        if (options.getAccumuloTable() != null && options.isDirect() && !cmgr.isDirectModeAccumuloSupported()) {
            throw new IOException("Direct mode is incompatible with Accumulo. Please remove the parameter --direct");
        }
        if (options.getHBaseTable() != null && options.isDirect() && !cmgr.isDirectModeHBaseSupported()) {
            throw new IOException("Direct mode is incompatible with HBase. Please remove the parameter --direct");
        }
        if (stagingTableName != null) {
            if (cmgr.supportsStagingForExport()) {
                LOG.info((Object)("Data will be staged in the table: " + stagingTableName));
                tableName = stagingTableName;
                stagingEnabled = true;
            } else {
                throw new ExportException("The active connection manager (" + cmgr.getClass().getCanonicalName() + ") does not support staging of data for export. Please retry without specifying the --staging-table option.");
            }
        }
        String tableClassName = null;
        if (!cmgr.isORMFacilitySelfManaged()) {
            tableClassName = new TableClassName(options).getClassForTable(outputTableName);
        }
        String ormJarFile = this.context.getJarFile();
        LOG.info((Object)("Beginning export of " + outputTableName));
        this.loadJars(conf, ormJarFile, tableClassName);
        if (stagingEnabled) {
            if (options.doClearStagingTable()) {
                try {
                    cmgr.deleteAllRecords(stagingTableName);
                }
                catch (SQLException ex) {
                    throw new ExportException("Failed to empty staging table before export run", ex);
                }
            }
            try {
                long rowCount = cmgr.getTableRowCount(stagingTableName);
                if (rowCount != 0L) {
                    throw new ExportException("The specified staging table (" + stagingTableName + ") is not empty. To force deletion of its data, please retry with --clear-staging-table option.");
                }
            }
            catch (SQLException ex) {
                throw new ExportException("Failed to count data rows in staging table: " + stagingTableName, ex);
            }
        }
        Job job = this.createJob(conf);
        try {
            job.getConfiguration().set("mapred.jar", ormJarFile);
            if (options.getMapreduceJobName() != null) {
                job.setJobName(options.getMapreduceJobName());
            }
            this.propagateOptionsToJob(job);
            if (this.isHCatJob) {
                LOG.info((Object)"Configuring HCatalog for export job");
                SqoopHCatUtilities hCatUtils = SqoopHCatUtilities.instance();
                hCatUtils.configureHCat(options, job, cmgr, tableName, job.getConfiguration());
            }
            this.configureInputFormat(job, tableName, tableClassName, null);
            this.configureOutputFormat(job, tableName, tableClassName);
            this.configureMapper(job, tableName, tableClassName);
            this.configureNumTasks(job);
            this.cacheJars(job, this.context.getConnManager());
            this.jobSetup(job);
            this.setJob(job);
            boolean success = this.runJob(job);
            if (!success) {
                LOG.error((Object)"Export job failed!");
                throw new ExportException("Export job failed!");
            }
            if (options.isValidationEnabled()) {
                this.validateExport(tableName, conf, job);
            }
            if (this.isHCatJob) {
                LOG.info((Object)"Publishing HCatalog export job data to Listeners");
                PublishJobData.publishJobData(conf, options, OPERATION, tableName, this.startTime);
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        finally {
            this.unloadJars();
            this.jobTeardown(job);
        }
        if (stagingEnabled) {
            try {
                LOG.info((Object)"Starting to migrate data from staging table to destination.");
                cmgr.migrateData(stagingTableName, outputTableName);
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Failed to move data from staging table (" + stagingTableName + ") to target table (" + outputTableName + ")", ex);
                throw new ExportException("Failed to move data from staging table", ex);
            }
        }
    }

    protected void validateExport(String tableName, Configuration conf, Job job) throws ExportException {
        LOG.debug((Object)"Validating exported data.");
        try {
            ValidationContext validationContext = new ValidationContext(this.getRowCountFromHadoop(job), this.getRowCountFromDB(this.context.getConnManager(), tableName));
            this.doValidate(this.options, conf, validationContext);
        }
        catch (ValidationException e) {
            throw new ExportException("Error validating row counts", e);
        }
        catch (SQLException e) {
            throw new ExportException("Error retrieving DB target row count", e);
        }
        catch (IOException e) {
            throw new ExportException("Error retrieving source row count", e);
        }
        catch (InterruptedException e) {
            throw new ExportException("Error retrieving source row count", e);
        }
    }

    @Deprecated
    protected boolean inputIsSequenceFiles() {
        try {
            return ExportJobBase.isSequenceFiles(this.context.getOptions().getConf(), this.getInputPath());
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Could not check file format for export; assuming text");
            return false;
        }
    }

    protected FileType getInputFileType() {
        if (this.isHCatJob) {
            return FileType.HCATALOG_MANAGED_FILE;
        }
        try {
            return ExportJobBase.getFileType(this.context.getOptions().getConf(), this.getInputPath());
        }
        catch (IOException ioe) {
            return FileType.UNKNOWN;
        }
    }

    protected void jobSetup(Job job) throws IOException, ExportException {
    }

    protected void jobTeardown(Job job) throws IOException, ExportException {
    }

    @Override
    protected void propagateOptionsToJob(Job job) {
        super.propagateOptionsToJob(job);
        Configuration conf = job.getConfiguration();
        int sqoopMaxAttempts = conf.getInt(SQOOP_EXPORT_MAP_TASK_MAX_ATTEMTPS, 1);
        if (sqoopMaxAttempts > 0) {
            conf.setInt("mapreduce.map.maxattempts", sqoopMaxAttempts);
        }
    }

    public static enum FileType {
        SEQUENCE_FILE,
        AVRO_DATA_FILE,
        HCATALOG_MANAGED_FILE,
        PARQUET_FILE,
        UNKNOWN;

    }
}

