/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.ExportJobContext;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.manager.SQLServerManager;
import org.apache.sqoop.mapreduce.SQLServerResilientExportOutputFormat;
import org.apache.sqoop.mapreduce.SQLServerResilientUpdateOutputFormat;
import org.apache.sqoop.mapreduce.db.SQLServerConnectionFailureHandler;
import org.apache.sqoop.mapreduce.db.SQLServerDBInputFormat;
import org.apache.sqoop.mapreduce.sqlserver.SqlServerExportBatchOutputFormat;

public class SqlServerManagerContextConfigurator {
    public static final String RESILIENT_OPTION = "resilient";

    private boolean isResilientOperation(SqoopOptions options) {
        String[] extraArgs = options.getExtraArgs();
        if (extraArgs != null) {
            for (int iArg = 0; iArg < extraArgs.length; ++iArg) {
                String currentArg = extraArgs[iArg];
                if (!currentArg.startsWith("--") || !currentArg.substring(2).equalsIgnoreCase(RESILIENT_OPTION)) continue;
                return true;
            }
        }
        return false;
    }

    public void configureContextForExport(ExportJobContext context) {
        if (this.isResilientOperation(context.getOptions())) {
            context.setOutputFormatClass(SQLServerResilientExportOutputFormat.class);
            this.configureConnectionRecoveryForExport(context);
        } else {
            context.setOutputFormatClass(SqlServerExportBatchOutputFormat.class);
        }
    }

    private void configureConnectionRecoveryForExport(ExportJobContext context) {
        Configuration conf = context.getOptions().getConf();
        String clsFailureHandler = conf.get("sqoop.export.failure.handler.class");
        if (clsFailureHandler == null) {
            conf.set("sqoop.export.failure.handler.class", SQLServerConnectionFailureHandler.class.getName());
        }
    }

    private void configureConnectionRecoveryForImport(ImportJobContext context) {
        Configuration conf = context.getOptions().getConf();
        context.setInputFormat(SQLServerDBInputFormat.class);
        if (conf.get("sqoop.import.failure.handler.class") == null) {
            conf.set("sqoop.import.failure.handler.class", SQLServerConnectionFailureHandler.class.getName());
        }
    }

    public void configureContextForImport(ImportJobContext context, String splitCol) {
        if (this.isResilientOperation(context.getOptions()) && splitCol != null) {
            this.configureConnectionRecoveryForImport(context);
        }
    }

    public boolean configureContextForUpdate(ExportJobContext context, SQLServerManager manager) {
        boolean runAsExportJob = this.isResilientOperation(context.getOptions());
        if (runAsExportJob) {
            context.setConnManager(manager);
            context.setOutputFormatClass(SQLServerResilientUpdateOutputFormat.class);
            this.configureConnectionRecoveryForExport(context);
        }
        return runAsExportJob;
    }
}

