/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.util.DirectImportUtils;

public final class MySQLUtils {
    public static final Log LOG = LogFactory.getLog((String)MySQLUtils.class.getName());
    public static final String MYSQL_DUMP_CMD = "mysqldump";
    public static final String MYSQL_IMPORT_CMD = "mysqlimport";
    public static final String OUTPUT_FIELD_DELIM_KEY = "sqoop.output.field.delim";
    public static final String OUTPUT_RECORD_DELIM_KEY = "sqoop.output.record.delim";
    public static final String OUTPUT_ENCLOSED_BY_KEY = "sqoop.output.enclosed.by";
    public static final String OUTPUT_ESCAPED_BY_KEY = "sqoop.output.escaped.by";
    public static final String OUTPUT_ENCLOSE_REQUIRED_KEY = "sqoop.output.enclose.required";
    public static final String TABLE_NAME_KEY = ConfigurationHelper.getDbInputTableNameProperty();
    public static final String CONNECT_STRING_KEY = ConfigurationHelper.getDbUrlProperty();
    public static final String USERNAME_KEY = ConfigurationHelper.getDbUsernameProperty();
    public static final String WHERE_CLAUSE_KEY = ConfigurationHelper.getDbInputConditionsProperty();
    public static final String EXTRA_ARGS_KEY = "sqoop.mysql.extra.args";
    public static final String MYSQL_DEFAULT_CHARSET = "ISO_8859_1";

    private MySQLUtils() {
    }

    public static boolean outputDelimsAreMySQL(Configuration conf) {
        return ',' == (char)conf.getInt(OUTPUT_FIELD_DELIM_KEY, 0) && '\n' == (char)conf.getInt(OUTPUT_RECORD_DELIM_KEY, 0) && '\'' == (char)conf.getInt(OUTPUT_ENCLOSED_BY_KEY, 0) && '\\' == (char)conf.getInt(OUTPUT_ESCAPED_BY_KEY, 0) && !conf.getBoolean(OUTPUT_ENCLOSE_REQUIRED_KEY, false);
    }

    public static String writePasswordFile(Configuration conf) throws IOException {
        String tmpDir = conf.get("job.local.dir", "/tmp/");
        File tempFile = File.createTempFile("mysql-cnf", ".cnf", new File(tmpDir));
        DirectImportUtils.setFilePermissions(tempFile, "0600");
        String password = DBConfiguration.getPassword((JobConf)conf);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFile)));
        w.write("[client]\n");
        w.write("password=" + password + "\n");
        w.close();
        return tempFile.toString();
    }
}

