/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import java.io.IOException;
import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sqoop.db.DriverManagerJdbcConnectionFactory;

public class HiveServer2ConnectionFactory
extends DriverManagerJdbcConnectionFactory {
    private static final Log LOG = LogFactory.getLog((String)HiveServer2ConnectionFactory.class.getName());
    private static final String HS2_DRIVER_CLASS = "org.apache.hive.jdbc.HiveDriver";

    public HiveServer2ConnectionFactory(String connectionString, String username, String password) {
        super(HS2_DRIVER_CLASS, connectionString, username, password);
    }

    public HiveServer2ConnectionFactory(String connectionString, String username) {
        this(connectionString, username, null);
    }

    @Override
    public Connection createConnection() {
        LOG.info((Object)("Creating connection to HiveServer2 as: " + this.getCurrentUser()));
        return super.createConnection();
    }

    private String getCurrentUser() {
        try {
            return UserGroupInformation.getCurrentUser().toString();
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to determine current user.", (Throwable)e);
            return "";
        }
    }
}

