/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.hbase.PutTransformer;
import org.apache.sqoop.hbase.ToStringPutTransformer;
import org.apache.sqoop.lib.FieldMapProcessor;
import org.apache.sqoop.lib.FieldMappable;
import org.apache.sqoop.lib.ProcessingException;

public class HBasePutProcessor
implements Closeable,
Configurable,
FieldMapProcessor {
    public static final Log LOG = LogFactory.getLog((String)HBasePutProcessor.class.getName());
    public static final String TABLE_NAME_KEY = "sqoop.hbase.insert.table";
    public static final String COL_FAMILY_KEY = "sqoop.hbase.insert.column.family";
    public static final String ROW_KEY_COLUMN_KEY = "sqoop.hbase.insert.row.key.column";
    public static final String NULL_INCREMENTAL_MODE = "hbase.null.incremental.mode";
    public static final String TRANSFORMER_CLASS_KEY = "sqoop.hbase.insert.put.transformer.class";
    public static final String BULK_LOAD_ENABLED_KEY = "sqoop.hbase.bulk.load.enabled";
    public static final String ADD_ROW_KEY = "sqoop.hbase.add.row.key";
    public static final boolean ADD_ROW_KEY_DEFAULT = false;
    private Configuration conf;
    private PutTransformer putTransformer;
    private Connection hbaseConnection;
    private BufferedMutator bufferedMutator;

    public HBasePutProcessor() {
    }

    HBasePutProcessor(Configuration conf, PutTransformer putTransformer, Connection hbaseConnection, BufferedMutator bufferedMutator) {
        this.conf = conf;
        this.putTransformer = putTransformer;
        this.hbaseConnection = hbaseConnection;
        this.bufferedMutator = bufferedMutator;
    }

    public void setConf(Configuration config) {
        this.conf = config;
        Class xformerClass = this.conf.getClass(TRANSFORMER_CLASS_KEY, ToStringPutTransformer.class);
        this.putTransformer = (PutTransformer)ReflectionUtils.newInstance((Class)xformerClass, (Configuration)this.conf);
        if (null == this.putTransformer) {
            throw new RuntimeException("Could not instantiate PutTransformer.");
        }
        this.putTransformer.init(this.conf);
        this.initHBaseMutator();
    }

    private void initHBaseMutator() {
        String tableName = this.conf.get(TABLE_NAME_KEY, null);
        try {
            this.hbaseConnection = ConnectionFactory.createConnection((Configuration)this.conf);
            this.bufferedMutator = this.hbaseConnection.getBufferedMutator(TableName.valueOf((String)tableName));
        }
        catch (IOException e) {
            if (this.hbaseConnection != null) {
                try {
                    this.hbaseConnection.close();
                }
                catch (IOException connCloseException) {
                    LOG.error((Object)"Cannot close HBase connection.", (Throwable)connCloseException);
                }
            }
            throw new RuntimeException("Could not create mutator for HBase table " + tableName, e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void accept(FieldMappable record) throws IOException, ProcessingException {
        Map<String, Object> fields = record.getFieldMap();
        List<Mutation> mutationList = this.putTransformer.getMutationCommand(fields);
        if (mutationList == null) {
            return;
        }
        for (Mutation mutation : mutationList) {
            if (!this.canAccept(mutation)) continue;
            if (!mutation.isEmpty()) {
                this.bufferedMutator.mutate(mutation);
                continue;
            }
            this.logEmptyMutation(mutation);
        }
    }

    private void logEmptyMutation(Mutation mutation) {
        String action = null;
        if (mutation instanceof Put) {
            action = "insert";
        } else if (mutation instanceof Delete) {
            action = "delete";
        }
        LOG.warn((Object)("Could not " + action + " row with no columns for row-key column: " + Bytes.toString((byte[])mutation.getRow())));
    }

    private boolean canAccept(Mutation mutation) {
        return mutation != null && (mutation instanceof Put || mutation instanceof Delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.bufferedMutator.flush();
        }
        finally {
            try {
                this.bufferedMutator.close();
            }
            finally {
                try {
                    this.hbaseConnection.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Cannot close HBase connection.", (Throwable)e);
                }
            }
        }
    }
}

