/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.db.decorator;

import java.security.PrivilegedAction;
import java.sql.Connection;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sqoop.authentication.KerberosAuthenticator;
import org.apache.sqoop.db.JdbcConnectionFactory;
import org.apache.sqoop.db.decorator.JdbcConnectionFactoryDecorator;

public class KerberizedConnectionFactoryDecorator
extends JdbcConnectionFactoryDecorator {
    private final KerberosAuthenticator authenticator;

    public KerberizedConnectionFactoryDecorator(JdbcConnectionFactory decorated, KerberosAuthenticator authenticator) {
        super(decorated);
        this.authenticator = authenticator;
    }

    @Override
    public Connection createConnection() {
        UserGroupInformation ugi = this.authenticator.authenticate();
        return (Connection)ugi.doAs((PrivilegedAction)new PrivilegedAction<Connection>(){

            @Override
            public Connection run() {
                return KerberizedConnectionFactoryDecorator.this.decorated.createConnection();
            }
        });
    }

    public KerberosAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

