/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.Reader;
import org.apache.orc.impl.AcidStats;

public class OrcAcidUtils {
    public static final String ACID_STATS = "hive.acid.stats";
    public static final String DELTA_SIDE_FILE_SUFFIX = "_flush_length";
    private static final Charset utf8 = Charset.forName("UTF-8");
    private static final CharsetDecoder utf8Decoder = utf8.newDecoder();

    public static Path getSideFile(Path main) {
        return new Path(main + DELTA_SIDE_FILE_SUFFIX);
    }

    public static long getLastFlushLength(FileSystem fs, Path deltaFile) throws IOException {
        Path lengths = OrcAcidUtils.getSideFile(deltaFile);
        long result = Long.MAX_VALUE;
        if (fs.exists(lengths)) {
            try {
                FSDataInputStream stream = fs.open(lengths);
                result = -1L;
                while (stream.available() > 0) {
                    result = stream.readLong();
                }
                stream.close();
                return result;
            }
            catch (IOException ioe) {
                return result;
            }
        }
        return result;
    }

    public static AcidStats parseAcidStats(Reader reader) {
        if (reader.hasMetadataValue(ACID_STATS)) {
            try {
                ByteBuffer val = reader.getMetadataValue(ACID_STATS).duplicate();
                return new AcidStats(utf8Decoder.decode(val).toString());
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException("Bad string encoding for hive.acid.stats", e);
            }
        }
        return null;
    }
}

