/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ObjectCacheWrapper
implements ObjectCache {
    private final String queryId;
    private final ObjectCache globalCache;

    public ObjectCacheWrapper(ObjectCache globalCache, String queryId) {
        this.queryId = queryId;
        this.globalCache = globalCache;
    }

    @Override
    public void release(String key) {
        this.globalCache.release(this.makeKey(key));
    }

    @Override
    public <T> T retrieve(String key, Callable<T> fn) throws HiveException {
        return this.globalCache.retrieve(this.makeKey(key), fn);
    }

    @Override
    public <T> Future<T> retrieveAsync(String key, Callable<T> fn) throws HiveException {
        return this.globalCache.retrieveAsync(this.makeKey(key), fn);
    }

    @Override
    public void remove(String key) {
        this.globalCache.remove(this.makeKey(key));
    }

    private String makeKey(String key) {
        return this.queryId + "_" + key;
    }
}

