/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.NoDataBandType;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndDetailsHandler;
import org.pentaho.reporting.engine.classic.core.states.process.InlineSubreportProcessor;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessDetailsHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class BeginDetailsHandler
implements AdvanceHandler {
    public static final BeginDetailsHandler HANDLER = new BeginDetailsHandler();

    private BeginDetailsHandler() {
    }

    @Override
    public int getEventCode() {
        return 16;
    }

    @Override
    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        NoDataBand childs;
        ProcessState next = state.deriveForAdvance();
        next.fireReportEvent();
        OutputProcessorMetaData outputProcessorMetaData = next.getFlowController().getReportContext().getOutputProcessorMetaData();
        if ((outputProcessorMetaData.isFeatureSupported(OutputProcessorFeature.DESIGNTIME) || next.getNumberOfRows() == 0) && (childs = next.getReport().getNoDataBand()) != null) {
            return InlineSubreportProcessor.processInline(next, childs);
        }
        return next;
    }

    @Override
    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        next.setInItemGroup(true);
        int numberOfRows = next.getNumberOfRows();
        if (numberOfRows > 0) {
            next.setAdvanceHandler(ProcessDetailsHandler.HANDLER);
            return next;
        }
        next.setAdvanceHandler(EndDetailsHandler.HANDLER);
        ReportElement[] childs = next.getReport().getChildElementsByType(NoDataBandType.INSTANCE);
        if (childs.length > 0) {
            return InlineSubreportProcessor.processBandedSubReports(next, (RootLevelBand)childs[0]);
        }
        return next;
    }

    @Override
    public boolean isFinish() {
        return false;
    }

    @Override
    public boolean isRestoreHandler() {
        return false;
    }
}

