/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlContentGenerator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriteException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.ContentUrlReWriteService;
import org.pentaho.reporting.libraries.base.encoder.UnsupportedEncoderException;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultHtmlContentGenerator
implements HtmlContentGenerator {
    private static final Log logger = LogFactory.getLog(DefaultHtmlContentGenerator.class);
    private final HashSet<String> validRawTypes;
    private ResourceManager resourceManager;
    private HashMap<ResourceKey, String> knownResources;
    private HashMap<String, String> knownImages = new HashMap();
    private boolean copyExternalImages;
    private ContentLocation dataLocation;
    private NameGenerator dataNameGenerator;
    private ContentUrlReWriteService rewriterService;

    public DefaultHtmlContentGenerator(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.knownResources = new HashMap();
        this.validRawTypes = new HashSet();
        this.validRawTypes.add("image/gif");
        this.validRawTypes.add("image/x-xbitmap");
        this.validRawTypes.add("image/gi_");
        this.validRawTypes.add("image/jpeg");
        this.validRawTypes.add("image/jpg");
        this.validRawTypes.add("image/jp_");
        this.validRawTypes.add("application/jpg");
        this.validRawTypes.add("application/x-jpg");
        this.validRawTypes.add("image/pjpeg");
        this.validRawTypes.add("image/pipeg");
        this.validRawTypes.add("image/vnd.swiftview-jpeg");
        this.validRawTypes.add("image/x-xbitmap");
        this.validRawTypes.add("image/png");
        this.validRawTypes.add("application/png");
        this.validRawTypes.add("application/x-png");
    }

    public void setDataWriter(ContentLocation dataLocation, NameGenerator dataNameGenerator, ContentUrlReWriteService rewriterService) {
        this.dataNameGenerator = dataNameGenerator;
        this.dataLocation = dataLocation;
        this.rewriterService = rewriterService;
    }

    @Override
    public void setCopyExternalImages(boolean copyExternalImages) {
        this.copyExternalImages = copyExternalImages;
    }

    public boolean isCopyExternalImages() {
        return this.copyExternalImages;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public void registerFailure(ResourceKey source) {
        this.knownResources.put(source, null);
    }

    @Override
    public void registerContent(ResourceKey source, String name) {
        this.knownResources.put(source, name);
    }

    @Override
    public boolean isRegistered(ResourceKey source) {
        return this.knownResources.containsKey(source);
    }

    @Override
    public String getRegisteredName(ResourceKey source) {
        String o = this.knownResources.get(source);
        if (o != null) {
            return o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeRaw(ResourceKey source) throws IOException {
        block13: {
            URL url;
            String protocol;
            Object identifier;
            if (source == null) {
                throw new NullPointerException();
            }
            if (!this.copyExternalImages && (identifier = source.getIdentifier()) instanceof URL && ("http".equalsIgnoreCase(protocol = (url = (URL)identifier).getProtocol()) || "https".equalsIgnoreCase(protocol) || "ftp".equalsIgnoreCase(protocol))) {
                return url.toExternalForm();
            }
            if (this.dataLocation == null) {
                return null;
            }
            try {
                ContentItem item;
                ResourceData resourceData = this.resourceManager.load(source);
                String mimeType = this.queryMimeType(resourceData);
                if (!this.isValidImage(mimeType) || !(item = this.dataLocation.createItem(this.dataNameGenerator.generateName(this.extractFilename(resourceData), mimeType))).isWriteable()) break block13;
                item.setAttribute("org.jfree.repository", "content-type", (Object)mimeType);
                try (BufferedInputStream stream = new BufferedInputStream(resourceData.getResourceAsStream(this.resourceManager));
                     BufferedOutputStream outputStream = new BufferedOutputStream(item.getOutputStream());){
                    IOUtils.getInstance().copyStreams((InputStream)stream, (OutputStream)outputStream);
                }
                return this.rewriterService.rewriteContentDataItem(item);
            }
            catch (ResourceLoadingException resourceData) {
            }
            catch (ContentIOException resourceData) {
            }
            catch (URLRewriteException e) {
                logger.warn((Object)"Rewriting the URL failed.", (Throwable)e);
                throw new RuntimeException("Failed", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeImage(ImageContainer image, String encoderType, float quality, boolean alpha) throws ContentIOException, IOException {
        String cacheKey;
        if (image == null) {
            throw new NullPointerException();
        }
        if (this.dataLocation == null) {
            return null;
        }
        if (image instanceof URLImageContainer) {
            URLImageContainer uic = (URLImageContainer)image;
            cacheKey = uic.getSourceURLString();
            String retval = this.knownImages.get(cacheKey);
            if (retval != null) {
                return retval;
            }
            String sourceURLString = uic.getSourceURLString();
            if (!uic.isLoadable() && sourceURLString != null) {
                this.knownImages.put(cacheKey, sourceURLString);
                return sourceURLString;
            }
        } else {
            cacheKey = null;
        }
        try {
            ImageData data = this.getImageData(image, encoderType, quality, alpha);
            if (data == null) {
                return null;
            }
            String filename = IOUtils.getInstance().stripFileExtension(data.getOriginalFileName());
            ContentItem dataFile = this.dataLocation.createItem(this.dataNameGenerator.generateName(filename, data.getMimeType()));
            String contentURL = this.rewriterService.rewriteContentDataItem(dataFile);
            try (BufferedOutputStream out = new BufferedOutputStream(dataFile.getOutputStream());){
                ((OutputStream)out).write(data.getImageData());
                ((OutputStream)out).flush();
            }
            if (cacheKey != null) {
                this.knownImages.put(cacheKey, contentURL);
            }
            return contentURL;
        }
        catch (ContentCreationException cce) {
            logger.warn((Object)("Failed to create the content image: Reason given was: " + cce.getMessage()));
            return null;
        }
        catch (URLRewriteException re) {
            logger.warn((Object)("Failed to write the URL: Reason given was: " + re.getMessage()));
            return null;
        }
        catch (UnsupportedEncoderException e) {
            logger.warn((Object)("Failed to write the URL: Reason given was: " + e.getMessage()));
            return null;
        }
    }

    private String queryMimeType(ResourceData resourceData) throws ResourceLoadingException, IOException {
        Object contentType = resourceData.getAttribute("content-type");
        if (contentType instanceof String) {
            return (String)contentType;
        }
        byte[] data = new byte[12];
        resourceData.getResource(this.resourceManager, data, 0L, data.length);
        return this.queryMimeType(data);
    }

    private String queryMimeType(byte[] data) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        if (this.isGIF(stream)) {
            return "image/gif";
        }
        stream.reset();
        if (this.isJPEG(stream)) {
            return "image/jpeg";
        }
        stream.reset();
        if (this.isPNG(stream)) {
            return "image/png";
        }
        return null;
    }

    private boolean isPNG(ByteArrayInputStream data) {
        int[] PNF_FINGERPRINT = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
        for (int i = 0; i < PNF_FINGERPRINT.length; ++i) {
            if (PNF_FINGERPRINT[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isJPEG(InputStream data) throws IOException {
        int[] JPG_FINGERPRINT_1 = new int[]{255, 216, 255, 224};
        for (int i = 0; i < JPG_FINGERPRINT_1.length; ++i) {
            if (JPG_FINGERPRINT_1[i] == data.read()) continue;
            return false;
        }
        if (data.read() == -1) {
            return false;
        }
        if (data.read() == -1) {
            return false;
        }
        int[] JPG_FINGERPRINT_2 = new int[]{74, 70, 73, 70, 0};
        for (int i = 0; i < JPG_FINGERPRINT_2.length; ++i) {
            if (JPG_FINGERPRINT_2[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isGIF(InputStream data) throws IOException {
        int[] GIF_FINGERPRINT = new int[]{71, 73, 70, 56};
        for (int i = 0; i < GIF_FINGERPRINT.length; ++i) {
            if (GIF_FINGERPRINT[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    private String extractFilename(ResourceData resourceData) {
        String filename = (String)resourceData.getAttribute("filename");
        if (filename == null) {
            return "image";
        }
        String pureFileName = IOUtils.getInstance().getFileName(filename);
        return IOUtils.getInstance().stripFileExtension(pureFileName);
    }

    private boolean isValidImage(String mimeType) {
        return this.validRawTypes.contains(mimeType);
    }

    private ImageData getImageData(ImageContainer image, String encoderType, float quality, boolean alpha) throws IOException, UnsupportedEncoderException {
        URLImageContainer urlImage;
        ResourceManager resourceManager = this.getResourceManager();
        ResourceKey url = null;
        if (image instanceof URLImageContainer && (url = (urlImage = (URLImageContainer)image).getResourceKey()) != null && urlImage.isLoadable() && this.isSupportedImageFormat(url)) {
            try {
                ResourceData data = resourceManager.load(url);
                byte[] imageData = data.getResource(resourceManager);
                String mimeType = this.queryMimeType(imageData);
                URL maybeRealURL = resourceManager.toURL(url);
                if (maybeRealURL != null) {
                    String originalFileName = IOUtils.getInstance().getFileName(maybeRealURL);
                    return new ImageData(imageData, mimeType, originalFileName);
                }
                return new ImageData(imageData, mimeType, "picture");
            }
            catch (ResourceException re) {
                logger.debug((Object)"Failed to process image as raw-data, trying as processed data next", (Throwable)re);
            }
        }
        if (image instanceof LocalImageContainer) {
            LocalImageContainer li = (LocalImageContainer)image;
            Image awtImage = li.getImage();
            if (awtImage == null && url != null) {
                try {
                    Resource resource = resourceManager.createDirectly((Object)url, Image.class);
                    awtImage = (Image)resource.getResource();
                }
                catch (ResourceException resource) {
                    // empty catch block
                }
            }
            if (awtImage != null) {
                URL maybeRealURL;
                byte[] imageData = RenderUtility.encodeImage(awtImage, encoderType, quality, alpha);
                String originalFileName = url != null ? ((maybeRealURL = resourceManager.toURL(url)) != null ? IOUtils.getInstance().getFileName(maybeRealURL) : "picture") : "picture";
                return new ImageData(imageData, encoderType, originalFileName);
            }
        }
        return null;
    }

    protected boolean isSupportedImageFormat(ResourceKey key) {
        ResourceManager resourceManager = this.getResourceManager();
        URL url = resourceManager.toURL(key);
        if (url == null) {
            return false;
        }
        String file = url.getFile();
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".jpg")) {
            return true;
        }
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".jpeg")) {
            return true;
        }
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".png")) {
            return true;
        }
        return StringUtils.endsWithIgnoreCase((String)file, (String)".gif");
    }

    public ContentItem createItem(String name, String mimeType) throws ContentIOException {
        return this.dataLocation.createItem(this.dataNameGenerator.generateName(name, mimeType));
    }

    public boolean isExternalContentAvailable() {
        return this.dataLocation != null;
    }

    private static class ImageData {
        private byte[] imageData;
        private String mimeType;
        private String originalFileName;

        private ImageData(byte[] imageData, String mimeType, String originalFileName) {
            if (imageData == null) {
                throw new NullPointerException();
            }
            if (mimeType == null) {
                throw new NullPointerException();
            }
            if (originalFileName == null) {
                throw new NullPointerException();
            }
            this.imageData = imageData;
            this.mimeType = mimeType;
            this.originalFileName = originalFileName;
        }

        public byte[] getImageData() {
            return this.imageData;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getOriginalFileName() {
            return this.originalFileName;
        }
    }
}

