/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.AbstractPageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.AllPageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.internal.XmlDocumentWriter;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.internal.XmlPageOutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class XmlPageOutputProcessor
extends AbstractPageableOutputProcessor {
    private OutputProcessorMetaData metaData;
    private OutputStream outputStream;
    private PageFlowSelector flowSelector;
    private XmlDocumentWriter writer;

    public XmlPageOutputProcessor(Configuration configuration, OutputStream outputStream) {
        this(outputStream, new XmlPageOutputProcessorMetaData());
    }

    public XmlPageOutputProcessor(OutputStream outputStream, OutputProcessorMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException("MetaData must not be null");
        }
        if (outputStream == null) {
            throw new NullPointerException("OutputStream must not be null");
        }
        this.outputStream = outputStream;
        this.flowSelector = new AllPageFlowSelector();
        this.metaData = metaData;
    }

    public void setFlowSelector(PageFlowSelector flowSelector) {
        if (flowSelector == null) {
            throw new NullPointerException();
        }
        this.flowSelector = flowSelector;
    }

    @Override
    protected PageFlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    @Override
    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        if (this.writer != null) {
            try {
                this.metaData.commit();
                this.writer.close();
            }
            catch (IOException e) {
                throw new InvalidReportStateException("Failed to close writer");
            }
        }
    }

    @Override
    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) throws ContentProcessingException {
        try {
            if (this.writer == null) {
                this.writer = new XmlDocumentWriter(this.outputStream, this.metaData);
                this.writer.open();
            }
            this.writer.processPhysicalPage(pageGrid, logicalPage, row, col);
        }
        catch (Exception e) {
            throw new ContentProcessingException("Failed to generate Xml document", e);
        }
    }

    @Override
    protected void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) throws ContentProcessingException {
        try {
            if (this.writer == null) {
                this.writer = new XmlDocumentWriter(this.outputStream, this.metaData);
                this.writer.open();
            }
            this.writer.processLogicalPage(key, logicalPage);
        }
        catch (Exception e) {
            throw new ContentProcessingException("Failed to generate Xml document", e);
        }
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }
}

