/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.csv;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.csv.CsvFormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastExportTemplateProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.TemplatingOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class CsvTemplateProducer
implements FastExportTemplateProducer {
    private OutputProcessorMetaData metaData;
    private SheetLayout sheetLayout;
    private String encoding;
    private HashMap<InstanceID, String> idMapping;
    private String template;
    private CSVQuoter quoter;

    public CsvTemplateProducer(OutputProcessorMetaData metaData, SheetLayout sheetLayout, String encoding) {
        this.metaData = metaData;
        this.sheetLayout = sheetLayout;
        this.encoding = encoding;
        this.idMapping = new HashMap();
        String separator = metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Separator", ",");
        if (separator.length() == 0) {
            throw new IllegalArgumentException("CSV separate cannot be an empty string.");
        }
        if (this.encoding == null) {
            this.encoding = metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
        }
        this.quoter = new CSVQuoter(separator.charAt(0));
    }

    @Override
    public void produceTemplate(LogicalPageBox pageBox) {
        TableContentProducer contentProducer = TemplatingOutputProcessor.produceTableLayout(pageBox, this.sheetLayout, this.metaData);
        SheetLayout sheetLayout = contentProducer.getSheetLayout();
        int columnCount = contentProducer.getColumnCount();
        int lastColumn = columnCount - 1;
        int startRow = contentProducer.getFinishedRows();
        int finishRow = contentProducer.getFilledRows();
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        for (int row = startRow; row < finishRow; ++row) {
            for (int col = 0; col < columnCount; col = (int)((short)(col + 1))) {
                RenderBox content = contentProducer.getContent(row, col);
                if (content == null) {
                    writer.print(this.quoter.getSeparator());
                    continue;
                }
                if (!content.isCommited()) {
                    throw new InvalidReportStateException("Uncommited content encountered");
                }
                long contentOffset = contentProducer.getContentOffset(row, col);
                TableRectangle rectangle = sheetLayout.getTableBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight(), null);
                if (!rectangle.isOrigin(col, row)) {
                    writer.print(this.quoter.getSeparator());
                    continue;
                }
                InstanceID instanceId = content.getNodeLayoutProperties().getInstanceId();
                String uuid = this.idMapping.get(instanceId);
                if (uuid == null) {
                    uuid = String.valueOf(this.idMapping.size());
                    this.idMapping.put(instanceId, uuid);
                }
                String formattedtext = "$(" + uuid + ")";
                writer.write(formattedtext);
                if (col < lastColumn) {
                    writer.print(this.quoter.getSeparator());
                }
                content.setFinishedTable(true);
            }
            writer.println();
        }
        writer.close();
        this.template = swriter.toString();
    }

    public CSVQuoter getQuoter() {
        return this.quoter;
    }

    public String getTemplate() {
        return this.template;
    }

    @Override
    public FormattedDataBuilder createDataBuilder() {
        MessageFormatSupport messageFormatSupport = new MessageFormatSupport();
        messageFormatSupport.setLocale(Locale.ENGLISH);
        messageFormatSupport.setFormatString(this.getTemplate());
        messageFormatSupport.setNullString("");
        return new CsvFormattedDataBuilder(this.idMapping, messageFormatSupport, this.getQuoter(), this.encoding);
    }
}

