/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class ItemMinFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private static final Log logger = LogFactory.getLog(ItemMinFunction.class);
    private Sequence<Comparable> min = new Sequence();
    private transient int lastGroupSequenceNumber;
    private String group;
    private String field;
    private String crosstabFilterGroup;

    public ItemMinFunction() {
    }

    public ItemMinFunction(String name) {
        this();
        this.setName(name);
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.clear();
    }

    protected void clear() {
        this.lastGroupSequenceNumber = 0;
        this.min.clear();
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.clear();
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String name) {
        this.group = name;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (this.field == null) {
            return;
        }
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Comparable)) {
            return;
        }
        try {
            Comparable compare = (Comparable)fieldValue;
            Comparable oldValue = this.min.get(this.lastGroupSequenceNumber);
            if (oldValue == null || oldValue.compareTo(compare) > 0) {
                this.min.set(this.lastGroupSequenceNumber, compare);
            }
        }
        catch (Exception e) {
            logger.error((Object)"ItemMinFunction.advanceItems(): problem adding number.");
        }
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public Object getValue() {
        return this.min.get(this.lastGroupSequenceNumber);
    }

    @Override
    public Expression getInstance() {
        ItemMinFunction function = (ItemMinFunction)super.getInstance();
        function.min = this.min.clone();
        function.lastGroupSequenceNumber = 0;
        return function;
    }

    @Override
    public Object clone() {
        try {
            ItemMinFunction function = (ItemMinFunction)super.clone();
            function.min = this.min.clone();
            return function;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }
}

