/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.staxpoi;

import org.apache.poi.ss.SpreadsheetVersion;

public class StaxUtil {
    private static final SpreadsheetVersion DEFAULT_SPREADSHEET_VERSION = SpreadsheetVersion.EXCEL2007;
    public static final int MAX_ROWS = DEFAULT_SPREADSHEET_VERSION.getMaxRows();
    public static final int MAX_COLUMNS = DEFAULT_SPREADSHEET_VERSION.getMaxColumns();

    public static int extractRowNumber(String position) {
        int startIndex;
        for (startIndex = 0; !Character.isDigit(position.charAt(startIndex)) && startIndex < position.length(); ++startIndex) {
        }
        String rowPart = position.substring(startIndex);
        return Integer.parseInt(rowPart);
    }

    public static int extractColumnNumber(String position) {
        int startIndex;
        for (startIndex = 0; !Character.isDigit(position.charAt(startIndex)) && startIndex < position.length(); ++startIndex) {
        }
        String colPart = position.substring(0, startIndex);
        return StaxUtil.parseColumnNumber(colPart);
    }

    public static final int parseColumnNumber(String columnIndicator) {
        int col = 0;
        for (int i = columnIndicator.length() - 1; i >= 0; --i) {
            char c = columnIndicator.charAt(i);
            int offset = 1 + Character.getNumericValue(c) - Character.getNumericValue('A');
            col = (int)((double)col + Math.pow(26.0, columnIndicator.length() - i - 1) * (double)offset);
        }
        return col;
    }
}

