/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.creditcardvalidator;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardValidatorData;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardValidatorMeta;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardVerifier;
import org.pentaho.di.trans.steps.creditcardvalidator.ReturnIndicator;

public class CreditCardValidator
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CreditCardValidatorMeta.class;
    private CreditCardValidatorMeta meta;
    private CreditCardValidatorData data;

    public CreditCardValidator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block16: {
            this.meta = (CreditCardValidatorMeta)smi;
            this.data = (CreditCardValidatorData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean isValid = false;
            String cardType = null;
            String unValid = null;
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                this.data.NrPrevFields = this.data.previousRowMeta.size();
                this.data.outputRowMeta = this.data.previousRowMeta;
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (Utils.isEmpty((CharSequence)this.meta.getDynamicField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"CreditCardValidator.Error.CardFieldMissing", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"CreditCardValidator.Error.CardFieldMissing", (String[])new String[0]));
                }
                if (this.data.indexOfField < 0) {
                    this.data.indexOfField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicField());
                    if (this.data.indexOfField < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"CreditCardValidator.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicField()}));
                    }
                }
                this.data.realResultFieldname = this.environmentSubstitute(this.meta.getResultFieldName());
                if (Utils.isEmpty((CharSequence)this.data.realResultFieldname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"CreditCardValidator.Exception.ResultFieldMissing", (String[])new String[0]));
                }
                this.data.realCardTypeFieldname = this.environmentSubstitute(this.meta.getCardType());
                this.data.realNotValidMsgFieldname = this.environmentSubstitute(this.meta.getNotValidMsg());
            }
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            for (int i = 0; i < this.data.NrPrevFields; ++i) {
                outputRow[i] = r[i];
            }
            try {
                String fieldvalue = this.getInputRowMeta().getString(r, this.data.indexOfField);
                if (this.meta.isOnlyDigits()) {
                    fieldvalue = Const.getDigitsOnly((String)fieldvalue);
                }
                ReturnIndicator rt = new ReturnIndicator();
                rt = CreditCardVerifier.CheckCC(fieldvalue);
                isValid = rt.CardValid;
                if (!Utils.isEmpty((CharSequence)this.data.realCardTypeFieldname)) {
                    cardType = rt.CardType;
                }
                if (!Utils.isEmpty((CharSequence)this.data.realNotValidMsgFieldname)) {
                    unValid = rt.UnValidMsg;
                }
                outputRow[this.data.NrPrevFields] = isValid;
                int rowIndex = this.data.NrPrevFields;
                ++rowIndex;
                if (!Utils.isEmpty((CharSequence)this.data.realCardTypeFieldname)) {
                    outputRow[rowIndex++] = cardType;
                }
                if (!Utils.isEmpty((CharSequence)this.data.realNotValidMsgFieldname)) {
                    outputRow[rowIndex++] = unValid;
                }
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"CreditCardValidator.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"CreditCardValidator.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block16;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "CreditCardValidator001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CreditCardValidatorMeta)smi;
        this.data = (CreditCardValidatorData)sdi;
        if (super.init(smi, sdi)) {
            if (Utils.isEmpty((CharSequence)this.meta.getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"CreditCardValidator.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CreditCardValidatorMeta)smi;
        this.data = (CreditCardValidatorData)sdi;
        super.dispose(smi, sdi);
    }
}

