/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.remote.MessageDecoder;
import org.pentaho.di.engine.api.remote.MessageEncoder;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.ael.websocket.MessageEventService;
import org.pentaho.di.trans.ael.websocket.SessionConfigurator;
import org.pentaho.di.trans.ael.websocket.exception.MessageEventFireEventException;

public class DaemonMessagesClientEndpoint
extends Endpoint {
    private static Class<?> PKG = DaemonMessagesClientEndpoint.class;
    private static final String EXCEPTION_SESSION_CLOSED = "DaemonMessagesClientEndpoint.Exception.SessionIsClosed";
    private static final String KETTLE_AEL_PDI_DAEMON_PRINCIPAL = "KETTLE_AEL_PDI_DAEMON_PRINCIPAL";
    private static final String KETTLE_AEL_PDI_DAEMON_KEYTAB = "KETTLE_AEL_PDI_DAEMON_KEYTAB";
    private static final String KETTLE_AEL_PDI_DAEMON_CONTEXT_REUSE = "KETTLE_AEL_PDI_DAEMON_CONTEXT_REUSE";
    private static final String Y_LWC = "y";
    private static final int MAX_TXT_MSG_BUF_SIZE = 500000;
    private static final int MAX_BIN_MSG_BUF_SIZE = 500000;
    private static final String URL_TEMPLATE = "%s://%s:%s/execution";
    private static final String PRFX_WS = "ws";
    private static final String PRFX_WS_SSL = "wss";
    private final MessageEventService messageEventService;
    private Session userSession = null;
    private String principal = null;
    private String keytab = null;
    private boolean reuseSparkContext = false;
    private AtomicBoolean alReadySendedStopMessage = new AtomicBoolean(false);

    public DaemonMessagesClientEndpoint(String host, String port, boolean ssl, MessageEventService messageEventService) throws KettleException {
        try {
            this.setAuthProperties();
            String url = String.format(URL_TEMPLATE, ssl ? PRFX_WS_SSL : PRFX_WS, host, port);
            URI uri = new URI(url);
            this.messageEventService = messageEventService;
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.connectToServer((Endpoint)this, ClientEndpointConfig.Builder.create().encoders(Collections.singletonList(MessageEncoder.class)).decoders(Collections.singletonList(MessageDecoder.class)).configurator((ClientEndpointConfig.Configurator)new SessionConfigurator(uri, this.keytab, this.principal)).build(), uri);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private void setAuthProperties() {
        Variables variables = new Variables();
        variables.initializeVariablesFrom(null);
        this.principal = variables.getVariable(KETTLE_AEL_PDI_DAEMON_PRINCIPAL, null);
        this.keytab = variables.getVariable(KETTLE_AEL_PDI_DAEMON_KEYTAB, null);
        String reuse = variables.getVariable(KETTLE_AEL_PDI_DAEMON_CONTEXT_REUSE, Boolean.FALSE.toString());
        this.reuseSparkContext = Boolean.TRUE.toString().equals(reuse.toLowerCase()) || Y_LWC.equals(reuse.toLowerCase());
    }

    public void onOpen(Session userSession, EndpointConfig endpointConfig) {
        this.userSession = userSession;
        this.userSession.setMaxTextMessageBufferSize(500000);
        this.userSession.setMaxBinaryMessageBufferSize(500000);
        userSession.addMessageHandler((MessageHandler)new MessageHandler.Whole<Message>(){

            public void onMessage(Message message) {
                try {
                    DaemonMessagesClientEndpoint.this.messageEventService.fireEvent(message);
                }
                catch (MessageEventFireEventException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        });
    }

    public void onClose(Session userSession, CloseReason reason) {
        this.userSession = null;
    }

    public void onError(Session userSession, Throwable thr) {
        throw new RuntimeException(thr);
    }

    public void sendMessage(ExecutionRequest request) throws KettleException {
        this.sessionValid();
        try {
            request.setReuseSparkContext(this.reuseSparkContext);
            this.userSession.getBasicRemote().sendObject((Object)request);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void sendMessage(StopMessage stopMessage) throws KettleException {
        this.sessionValid();
        try {
            if (!this.alReadySendedStopMessage.getAndSet(true)) {
                this.userSession.getBasicRemote().sendObject((Object)stopMessage);
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void close(String message) throws KettleException {
        this.sessionValid();
        try {
            if (this.userSession != null && this.userSession.isOpen()) {
                this.userSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, message));
            }
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void sessionValid() throws KettleException {
        if (this.userSession == null || !this.userSession.isOpen()) {
            throw new KettleException(BaseMessages.getString(PKG, (String)EXCEPTION_SESSION_CLOSED, (String[])new String[0]));
        }
    }
}

