/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;

@Explain(displayName="Truncate Table or Partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class TruncateTableDesc
extends DDLDesc
implements DDLDesc.DDLDescWithWriteId {
    private static final long serialVersionUID = 1L;
    private String tableName;
    private String fullTableName;
    private Map<String, String> partSpec;
    private List<Integer> columnIndexes;
    private Path inputDir;
    private Path outputDir;
    private ListBucketingCtx lbCtx;
    private ReplicationSpec replicationSpec;
    private long writeId = 0L;
    private boolean isTransactional;

    public TruncateTableDesc() {
    }

    public TruncateTableDesc(String tableName, Map<String, String> partSpec, ReplicationSpec replicationSpec) {
        this(tableName, partSpec, replicationSpec, null);
    }

    public TruncateTableDesc(String tableName, Map<String, String> partSpec, ReplicationSpec replicationSpec, Table table) {
        this.tableName = tableName;
        this.partSpec = partSpec;
        this.replicationSpec = replicationSpec;
        this.isTransactional = AcidUtils.isTransactionalTable(table);
        this.fullTableName = table == null ? tableName : Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)table.getTTable());
    }

    @Explain(displayName="TableName", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Explain(displayName="Partition Spec", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpec(Map<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    @Explain(displayName="Column Indexes")
    public List<Integer> getColumnIndexes() {
        return this.columnIndexes;
    }

    public void setColumnIndexes(List<Integer> columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    public Path getInputDir() {
        return this.inputDir;
    }

    public void setInputDir(Path inputDir) {
        this.inputDir = inputDir;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    public ListBucketingCtx getLbCtx() {
        return this.lbCtx;
    }

    public void setLbCtx(ListBucketingCtx lbCtx) {
        this.lbCtx = lbCtx;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    @Override
    public String getFullTableName() {
        return this.fullTableName;
    }

    @Override
    public boolean mayNeedWriteId() {
        return this.isTransactional;
    }
}

