/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public interface OpTreeSignatureFactory {
    public static final OpTreeSignatureFactory DIRECT = new Direct();

    public OpTreeSignature getSignature(Operator<? extends OperatorDesc> var1);

    public static OpTreeSignatureFactory direct() {
        return DIRECT;
    }

    public static OpTreeSignatureFactory newCache() {
        return new CachedFactory();
    }

    public static class CachedFactory
    implements OpTreeSignatureFactory {
        Map<Operator<? extends OperatorDesc>, OpTreeSignature> cache = new IdentityHashMap<Operator<? extends OperatorDesc>, OpTreeSignature>();

        @Override
        public OpTreeSignature getSignature(Operator<? extends OperatorDesc> op) {
            return this.cache.computeIfAbsent(op, k -> OpTreeSignature.of(op, this));
        }
    }

    public static class Direct
    implements OpTreeSignatureFactory {
        @Override
        public OpTreeSignature getSignature(Operator<? extends OperatorDesc> op) {
            return OpTreeSignature.of(op, this);
        }
    }
}

