/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model;

import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.model.IOperation;

public class Operation
implements IOperation {
    private String category;
    private ChangeType type;
    private String name;
    private String description;

    private Operation() {
    }

    public Operation(String category, ChangeType type, String name, String description) {
        this();
        this.category = category;
        this.type = type;
        this.name = name;
        this.description = description;
    }

    public Operation(String name, String description) {
        this("changeMetadata", ChangeType.METADATA, name, description);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public ChangeType getType() {
        return this.type;
    }

    @Override
    public void setType(ChangeType type) {
        this.type = type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName() + ": " + this.getDescription();
    }

    public static Operation getRenameOperation() {
        return new Operation("changeMetadata", ChangeType.METADATA, "modified", "name");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operation operation = (Operation)o;
        if (this.category != null ? !this.category.equals(operation.category) : operation.category != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(operation.description) : operation.description != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(operation.name) : operation.name != null) {
            return false;
        }
        return this.type == operation.type;
    }

    public int hashCode() {
        int result = this.category != null ? this.category.hashCode() : 0;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

