/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.service.AbstractService;

public class RouterHttpServer
extends AbstractService {
    protected static final String NAMENODE_ATTRIBUTE_KEY = "name.node";
    private Configuration conf;
    private final Router router;
    private HttpServer2 httpServer;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;

    public RouterHttpServer(Router router) {
        super(RouterHttpServer.class.getName());
        this.router = router;
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.conf = configuration;
        this.httpAddress = this.conf.getSocketAddr("dfs.federation.router.http-bind-host", "dfs.federation.router.http-address", "0.0.0.0:50071", 50071);
        this.httpsAddress = this.conf.getSocketAddr("dfs.federation.router.https-bind-host", "dfs.federation.router.https-address", "0.0.0.0:50072", 50072);
        super.serviceInit(this.conf);
    }

    protected void serviceStart() throws Exception {
        String webApp = "router";
        HttpServer2.Builder builder = DFSUtil.httpServerTemplateForNNAndJN(this.conf, this.httpAddress, this.httpsAddress, webApp, "dfs.namenode.kerberos.internal.spnego.principal", "dfs.namenode.keytab.file");
        this.httpServer = builder.build();
        this.httpServer.setAttribute(NAMENODE_ATTRIBUTE_KEY, (Object)this.router);
        this.httpServer.setAttribute("current.conf", (Object)this.conf);
        RouterHttpServer.setupServlets(this.httpServer, this.conf);
        this.httpServer.start();
        InetSocketAddress listenAddress = this.httpServer.getConnectorAddress(0);
        if (listenAddress != null) {
            this.httpAddress = new InetSocketAddress(this.httpAddress.getHostName(), listenAddress.getPort());
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        super.serviceStop();
    }

    private static void setupServlets(HttpServer2 httpServer, Configuration conf) {
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }
}

