/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hive.llap.daemon.FinishableStateUpdateHandler;
import org.apache.hadoop.hive.llap.daemon.impl.QueryInfo;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.tezplugins.LlapTezUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFragmentInfo {
    private static final Logger LOG = LoggerFactory.getLogger(QueryFragmentInfo.class);
    private final QueryInfo queryInfo;
    private final String vertexName;
    private final int fragmentNumber;
    private final int attemptNumber;
    private final LlapDaemonProtocolProtos.SignableVertexSpec vertexSpec;
    private final String fragmentIdString;

    public QueryFragmentInfo(QueryInfo queryInfo, String vertexName, int fragmentNumber, int attemptNumber, LlapDaemonProtocolProtos.SignableVertexSpec vertexSpec, String fragmentIdString) {
        Preconditions.checkNotNull((Object)queryInfo);
        Preconditions.checkNotNull((Object)vertexName);
        Preconditions.checkNotNull((Object)vertexSpec);
        this.queryInfo = queryInfo;
        this.vertexName = vertexName;
        this.fragmentNumber = fragmentNumber;
        this.attemptNumber = attemptNumber;
        this.vertexSpec = vertexSpec;
        this.fragmentIdString = fragmentIdString;
    }

    QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public LlapDaemonProtocolProtos.SignableVertexSpec getVertexSpec() {
        return this.vertexSpec;
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public int getFragmentNumber() {
        return this.fragmentNumber;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public String getFragmentIdentifierString() {
        return this.fragmentIdString;
    }

    public boolean canFinish() {
        List inputSpecList = this.vertexSpec.getInputSpecsList();
        boolean canFinish = true;
        if (inputSpecList != null && !inputSpecList.isEmpty()) {
            for (LlapDaemonProtocolProtos.IOSpecProto inputSpec : inputSpecList) {
                LlapDaemonProtocolProtos.SourceStateProto state;
                if (!LlapTezUtils.isSourceOfInterest((String)inputSpec.getIoDescriptor().getClassName()) || (state = (LlapDaemonProtocolProtos.SourceStateProto)this.queryInfo.getSourceStateMap().get(inputSpec.getConnectedVertexName())) != null && state == LlapDaemonProtocolProtos.SourceStateProto.S_SUCCEEDED) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cannot finish due to source: " + inputSpec.getConnectedVertexName());
                }
                canFinish = false;
                break;
            }
        }
        return canFinish;
    }

    public String[] getLocalDirs() throws IOException {
        return this.queryInfo.getLocalDirs();
    }

    public boolean registerForFinishableStateUpdates(FinishableStateUpdateHandler handler, boolean lastFinishableState) {
        LinkedList<String> sourcesOfInterest = new LinkedList<String>();
        List inputSpecList = this.vertexSpec.getInputSpecsList();
        if (inputSpecList != null && !inputSpecList.isEmpty()) {
            for (LlapDaemonProtocolProtos.IOSpecProto inputSpec : inputSpecList) {
                if (!LlapTezUtils.isSourceOfInterest((String)inputSpec.getIoDescriptor().getClassName())) continue;
                sourcesOfInterest.add(inputSpec.getConnectedVertexName());
            }
        }
        return this.queryInfo.registerForFinishableStateUpdates(handler, sourcesOfInterest, this, lastFinishableState);
    }

    public void unregisterForFinishableStateUpdates(FinishableStateUpdateHandler handler) {
        this.queryInfo.unregisterFinishableStateUpdate(handler);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryFragmentInfo that = (QueryFragmentInfo)o;
        if (this.fragmentNumber != that.fragmentNumber) {
            return false;
        }
        if (this.attemptNumber != that.attemptNumber) {
            return false;
        }
        return this.vertexName.equals(that.vertexName);
    }

    public int hashCode() {
        int result = this.vertexName.hashCode();
        result = 31 * result + this.fragmentNumber;
        result = 31 * result + this.attemptNumber;
        return result;
    }
}

