/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.DaemonId;
import org.apache.hadoop.hive.llap.daemon.ContainerRunner;
import org.apache.hadoop.hive.llap.daemon.FragmentCompletionHandler;
import org.apache.hadoop.hive.llap.daemon.HistoryLogger;
import org.apache.hadoop.hive.llap.daemon.KilledTaskHandler;
import org.apache.hadoop.hive.llap.daemon.QueryFailedHandler;
import org.apache.hadoop.hive.llap.daemon.impl.AMReporter;
import org.apache.hadoop.hive.llap.daemon.impl.LlapTokenChecker;
import org.apache.hadoop.hive.llap.daemon.impl.QueryFragmentInfo;
import org.apache.hadoop.hive.llap.daemon.impl.QueryIdentifier;
import org.apache.hadoop.hive.llap.daemon.impl.QueryTracker;
import org.apache.hadoop.hive.llap.daemon.impl.Scheduler;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskRunnerCallable;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.hive.llap.security.LlapSignerImpl;
import org.apache.hadoop.hive.llap.tez.Converters;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.apache.log4j.NDC;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.hadoop.shim.HadoopShimsLoader;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerRunnerImpl
extends CompositeService
implements ContainerRunner,
FragmentCompletionHandler,
QueryFailedHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerRunnerImpl.class);
    public static final String THREAD_NAME_FORMAT_PREFIX = "ContainerExecutor ";
    private final AMReporter amReporter;
    private final QueryTracker queryTracker;
    private final Scheduler<TaskRunnerCallable> executorService;
    private final AtomicReference<InetSocketAddress> localAddress;
    private final AtomicReference<Integer> localShufflePort;
    private final Map<String, String> localEnv = new HashMap<String, String>();
    private final long memoryPerExecutor;
    private final LlapDaemonExecutorMetrics metrics;
    private final Configuration conf;
    private final TaskRunnerCallable.ConfParams confParams;
    private final KilledTaskHandler killedTaskHandler = new KilledTaskHandlerImpl();
    private final HadoopShim tezHadoopShim;
    private final LlapSignerImpl signer;
    private final String clusterId;

    public ContainerRunnerImpl(Configuration conf, int numExecutors, int waitQueueSize, boolean enablePreemption, String[] localDirsBase, AtomicReference<Integer> localShufflePort, AtomicReference<InetSocketAddress> localAddress, long totalMemoryAvailableBytes, LlapDaemonExecutorMetrics metrics, AMReporter amReporter, ClassLoader classLoader, DaemonId daemonId) {
        super("ContainerRunnerImpl");
        this.conf = conf;
        Preconditions.checkState((numExecutors > 0 ? 1 : 0) != 0, (Object)("Invalid number of executors: " + numExecutors + ". Must be > 0"));
        this.localAddress = localAddress;
        this.localShufflePort = localShufflePort;
        this.amReporter = amReporter;
        this.signer = UserGroupInformation.isSecurityEnabled() ? new LlapSignerImpl(conf, daemonId) : null;
        this.clusterId = daemonId.getClusterString();
        this.queryTracker = new QueryTracker(conf, localDirsBase, this.clusterId);
        this.addIfService((Object)this.queryTracker);
        String waitQueueSchedulerClassName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WAIT_QUEUE_COMPARATOR_CLASS_NAME);
        this.executorService = new TaskExecutorService(numExecutors, waitQueueSize, waitQueueSchedulerClassName, enablePreemption, classLoader, metrics);
        this.addIfService(this.executorService);
        this.memoryPerExecutor = (long)((double)totalMemoryAvailableBytes * 0.8 / (double)numExecutors);
        this.metrics = metrics;
        this.confParams = new TaskRunnerCallable.ConfParams(conf.getInt("tez.task.am.heartbeat.interval-ms.max", 100), conf.getLong("tez.task.am.heartbeat.counter.interval-ms.max", 4000L), conf.getInt("tez.task.max-events-per-heartbeat", 500));
        this.tezHadoopShim = new HadoopShimsLoader(conf).getHadoopShim();
        LOG.info("ContainerRunnerImpl config: memoryPerExecutorDerviced=" + this.memoryPerExecutor);
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        LOG.info("Using ShufflePort: " + this.localShufflePort.get());
        AuxiliaryServiceHelper.setServiceDataIntoEnv((String)"mapreduce_shuffle", (ByteBuffer)ByteBuffer.allocate(4).putInt(this.localShufflePort.get()), this.localEnv);
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LlapDaemonProtocolProtos.SubmitWorkResponseProto submitWork(LlapDaemonProtocolProtos.SubmitWorkRequestProto request) throws IOException {
        Scheduler.SubmissionState submissionState;
        ByteString vertexBinary;
        LlapDaemonProtocolProtos.VertexOrBinary vob = request.getWorkSpec();
        LlapDaemonProtocolProtos.SignableVertexSpec vertex = vob.hasVertex() ? vob.getVertex() : null;
        ByteString byteString = vertexBinary = vob.hasVertexBinary() ? vob.getVertexBinary() : null;
        if (vertex != null && vertexBinary != null) {
            throw new IOException("Vertex and vertexBinary in VertexOrBinary cannot be set at the same time");
        }
        if (vertexBinary != null) {
            vertex = LlapDaemonProtocolProtos.SignableVertexSpec.parseFrom((ByteString)vob.getVertexBinary());
        }
        LlapTokenChecker.LlapTokenInfo tokenInfo = LlapTokenChecker.getTokenInfo(this.clusterId);
        if (tokenInfo.isSigningRequired) {
            this.checkSignature(vertex, vertexBinary, request, tokenInfo.userName);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Queueing container for execution: " + ContainerRunnerImpl.stringifySubmitRequest(request, vertex));
        }
        LlapDaemonProtocolProtos.VertexIdentifier vId = vertex.getVertexIdentifier();
        TezTaskAttemptID attemptId = Converters.createTaskAttemptId((LlapDaemonProtocolProtos.VertexIdentifier)vId, (int)request.getFragmentNumber(), (int)request.getAttemptNumber());
        String fragmentIdString = attemptId.toString();
        HistoryLogger.logFragmentStart(vId.getApplicationIdString(), request.getContainerIdString(), this.localAddress.get().getHostName(), vertex.getDagName(), vId.getDagId(), vertex.getVertexName(), request.getFragmentNumber(), request.getAttemptNumber());
        NDC.push((String)fragmentIdString);
        LlapDaemonProtocolProtos.SubmitWorkResponseProto.Builder responseBuilder = LlapDaemonProtocolProtos.SubmitWorkResponseProto.newBuilder();
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            env.putAll(this.localEnv);
            env.put(ApplicationConstants.Environment.USER.name(), vertex.getUser());
            TezTaskAttemptID taskAttemptId = TezTaskAttemptID.fromString((String)fragmentIdString);
            int dagIdentifier = taskAttemptId.getTaskID().getVertexID().getDAGId().getId();
            QueryIdentifier queryIdentifier = new QueryIdentifier(vId.getApplicationIdString(), dagIdentifier);
            Credentials credentials = new Credentials();
            DataInputBuffer dib = new DataInputBuffer();
            byte[] tokenBytes = request.getCredentialsBinary().toByteArray();
            dib.reset(tokenBytes, tokenBytes.length);
            credentials.readTokenStorageStream((DataInputStream)dib);
            Token jobToken = TokenCache.getSessionToken((Credentials)credentials);
            QueryFragmentInfo fragmentInfo = this.queryTracker.registerFragment(queryIdentifier, vId.getApplicationIdString(), vertex.getDagName(), dagIdentifier, vertex.getVertexName(), request.getFragmentNumber(), request.getAttemptNumber(), vertex.getUser(), vertex, (Token<JobTokenIdentifier>)jobToken, fragmentIdString, tokenInfo);
            Object[] localDirs = fragmentInfo.getLocalDirs();
            Preconditions.checkNotNull((Object)localDirs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dirs are: " + Arrays.toString(localDirs));
            }
            Configuration callableConf = new Configuration(this.getConfig());
            TaskRunnerCallable callable = new TaskRunnerCallable(request, fragmentInfo, callableConf, (ExecutionContext)new LlapExecutionContext(this.localAddress.get().getHostName(), this.queryTracker), env, credentials, this.memoryPerExecutor, this.amReporter, this.confParams, this.metrics, this.killedTaskHandler, this, this.tezHadoopShim, attemptId, vertex);
            submissionState = this.executorService.schedule(callable);
            if (LOG.isInfoEnabled()) {
                LOG.info("SubmissionState for {} : {} ", (Object)fragmentIdString, (Object)submissionState);
            }
            if (submissionState.equals((Object)Scheduler.SubmissionState.REJECTED)) {
                this.fragmentComplete(fragmentInfo);
                LlapDaemonProtocolProtos.SubmitWorkResponseProto submitWorkResponseProto = responseBuilder.setSubmissionState(LlapDaemonProtocolProtos.SubmissionStateProto.valueOf((String)submissionState.name())).build();
                return submitWorkResponseProto;
            }
            if (this.metrics != null) {
                this.metrics.incrExecutorTotalRequestsHandled();
            }
        }
        finally {
            NDC.pop();
        }
        responseBuilder.setSubmissionState(LlapDaemonProtocolProtos.SubmissionStateProto.valueOf((String)submissionState.name()));
        return responseBuilder.build();
    }

    private void checkSignature(LlapDaemonProtocolProtos.SignableVertexSpec vertex, ByteString vertexBinary, LlapDaemonProtocolProtos.SubmitWorkRequestProto request, String tokenUserName) throws SecurityException, IOException {
        if (!request.hasWorkSpecSignature()) {
            throw new SecurityException("Unsigned fragment not allowed");
        }
        if (vertexBinary == null) {
            ByteString.Output os = ByteString.newOutput();
            vertex.writeTo((OutputStream)os);
            vertexBinary = os.toByteString();
        }
        this.signer.checkSignature(vertexBinary.toByteArray(), request.getWorkSpecSignature().toByteArray(), (int)vertex.getSignatureKeyId());
        if (!vertex.hasUser() || !vertex.getUser().equals(tokenUserName)) {
            throw new SecurityException("LLAP token is for " + tokenUserName + " but the fragment is for " + (vertex.hasUser() ? vertex.getUser() : null));
        }
    }

    @Override
    public LlapDaemonProtocolProtos.SourceStateUpdatedResponseProto sourceStateUpdated(LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto request) throws IOException {
        LOG.info("Processing state update: " + this.stringifySourceStateUpdateRequest(request));
        QueryIdentifier queryId = new QueryIdentifier(request.getQueryIdentifier().getAppIdentifier(), request.getQueryIdentifier().getDagIdentifier());
        this.queryTracker.registerSourceStateChange(queryId, request.getSrcName(), request.getState());
        return LlapDaemonProtocolProtos.SourceStateUpdatedResponseProto.getDefaultInstance();
    }

    @Override
    public LlapDaemonProtocolProtos.QueryCompleteResponseProto queryComplete(LlapDaemonProtocolProtos.QueryCompleteRequestProto request) throws IOException {
        QueryIdentifier queryIdentifier = new QueryIdentifier(request.getQueryIdentifier().getAppIdentifier(), request.getQueryIdentifier().getDagIdentifier());
        LOG.info("Processing queryComplete notification for {}", (Object)queryIdentifier);
        List<QueryFragmentInfo> knownFragments = this.queryTracker.queryComplete(queryIdentifier, request.getDeleteDelay(), false);
        LOG.info("DBG: Pending fragment count for completed query {} = {}", (Object)queryIdentifier, (Object)knownFragments.size());
        for (QueryFragmentInfo fragmentInfo : knownFragments) {
            LOG.info("Issuing killFragment for completed query {} {}", (Object)queryIdentifier, (Object)fragmentInfo.getFragmentIdentifierString());
            this.executorService.killFragment(fragmentInfo.getFragmentIdentifierString());
        }
        return LlapDaemonProtocolProtos.QueryCompleteResponseProto.getDefaultInstance();
    }

    @Override
    public LlapDaemonProtocolProtos.TerminateFragmentResponseProto terminateFragment(LlapDaemonProtocolProtos.TerminateFragmentRequestProto request) throws IOException {
        String fragmentId = request.getFragmentIdentifierString();
        LOG.info("DBG: Received terminateFragment request for {}", (Object)fragmentId);
        QueryIdentifier queryId = this.executorService.findQueryByFragment(fragmentId);
        if (queryId != null && this.queryTracker.checkPermissionsForQuery(queryId)) {
            this.executorService.killFragment(fragmentId);
        }
        return LlapDaemonProtocolProtos.TerminateFragmentResponseProto.getDefaultInstance();
    }

    private String stringifySourceStateUpdateRequest(LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto request) {
        StringBuilder sb = new StringBuilder();
        QueryIdentifier queryIdentifier = new QueryIdentifier(request.getQueryIdentifier().getAppIdentifier(), request.getQueryIdentifier().getDagIdentifier());
        sb.append("queryIdentifier=").append(queryIdentifier).append(", ").append("sourceName=").append(request.getSrcName()).append(", ").append("state=").append(request.getState());
        return sb.toString();
    }

    public static String stringifySubmitRequest(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, LlapDaemonProtocolProtos.SignableVertexSpec vertex) {
        StringBuilder sb = new StringBuilder();
        sb.append("am_details=").append(request.getAmHost()).append(":").append(request.getAmPort());
        sb.append(", taskInfo=").append(vertex.getVertexIdentifier()).append(" fragment ").append(request.getFragmentNumber()).append(" attempt ").append(request.getAttemptNumber());
        sb.append(", user=").append(vertex.getUser());
        sb.append(", appIdString=").append(vertex.getVertexIdentifier().getApplicationIdString());
        sb.append(", appAttemptNum=").append(vertex.getVertexIdentifier().getAppAttemptNumber());
        sb.append(", containerIdString=").append(request.getContainerIdString());
        sb.append(", dagName=").append(vertex.getDagName());
        sb.append(", vertexName=").append(vertex.getVertexName());
        sb.append(", processor=").append(vertex.getProcessorDescriptor().getClassName());
        sb.append(", numInputs=").append(vertex.getInputSpecsCount());
        sb.append(", numOutputs=").append(vertex.getOutputSpecsCount());
        sb.append(", numGroupedInputs=").append(vertex.getGroupedInputSpecsCount());
        sb.append(", Inputs={");
        if (vertex.getInputSpecsCount() > 0) {
            for (LlapDaemonProtocolProtos.IOSpecProto ioSpec : vertex.getInputSpecsList()) {
                sb.append("{").append(ioSpec.getConnectedVertexName()).append(",").append(ioSpec.getIoDescriptor().getClassName()).append(",").append(ioSpec.getPhysicalEdgeCount()).append("}");
            }
        }
        sb.append("}");
        sb.append(", Outputs={");
        if (vertex.getOutputSpecsCount() > 0) {
            for (LlapDaemonProtocolProtos.IOSpecProto ioSpec : vertex.getOutputSpecsList()) {
                sb.append("{").append(ioSpec.getConnectedVertexName()).append(",").append(ioSpec.getIoDescriptor().getClassName()).append(",").append(ioSpec.getPhysicalEdgeCount()).append("}");
            }
        }
        sb.append("}");
        sb.append(", GroupedInputs={");
        if (vertex.getGroupedInputSpecsCount() > 0) {
            for (LlapDaemonProtocolProtos.GroupInputSpecProto group : vertex.getGroupedInputSpecsList()) {
                sb.append("{").append("groupName=").append(group.getGroupName()).append(", elements=").append(group.getGroupVerticesList()).append("}");
                sb.append(group.getGroupVerticesList());
            }
        }
        sb.append("}");
        LlapDaemonProtocolProtos.FragmentRuntimeInfo fragmentRuntimeInfo = request.getFragmentRuntimeInfo();
        sb.append(", FragmentRuntimeInfo={");
        sb.append("taskCount=").append(fragmentRuntimeInfo.getNumSelfAndUpstreamTasks());
        sb.append(", completedTaskCount=").append(fragmentRuntimeInfo.getNumSelfAndUpstreamCompletedTasks());
        sb.append(", dagStartTime=").append(fragmentRuntimeInfo.getDagStartTime());
        sb.append(", firstAttemptStartTime=").append(fragmentRuntimeInfo.getFirstAttemptStartTime());
        sb.append(", currentAttemptStartTime=").append(fragmentRuntimeInfo.getCurrentAttemptStartTime());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void fragmentComplete(QueryFragmentInfo fragmentInfo) {
        this.queryTracker.fragmentComplete(fragmentInfo);
    }

    @Override
    public void queryFailed(QueryIdentifier queryIdentifier) {
        List<QueryFragmentInfo> knownFragments;
        LOG.info("Processing query failed notification for {}", (Object)queryIdentifier);
        try {
            knownFragments = this.queryTracker.queryComplete(queryIdentifier, -1L, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.info("DBG: Pending fragment count for failed query {} = {}", (Object)queryIdentifier, (Object)knownFragments.size());
        for (QueryFragmentInfo fragmentInfo : knownFragments) {
            LOG.info("DBG: Issuing killFragment for failed query {} {}", (Object)queryIdentifier, (Object)fragmentInfo.getFragmentIdentifierString());
            this.executorService.killFragment(fragmentInfo.getFragmentIdentifierString());
        }
    }

    public Set<String> getExecutorStatus() {
        return this.executorService.getExecutorsStatus();
    }

    private class KilledTaskHandlerImpl
    implements KilledTaskHandler {
        private KilledTaskHandlerImpl() {
        }

        @Override
        public void taskKilled(String amLocation, int port, String user, Token<JobTokenIdentifier> jobToken, QueryIdentifier queryIdentifier, TezTaskAttemptID taskAttemptId) {
            ContainerRunnerImpl.this.amReporter.taskKilled(amLocation, port, user, jobToken, queryIdentifier, taskAttemptId);
        }
    }

    private static class LlapExecutionContext
    extends ExecutionContextImpl
    implements TezProcessor.Hook {
        private final QueryTracker queryTracker;

        public LlapExecutionContext(String hostname, QueryTracker queryTracker) {
            super(hostname);
            this.queryTracker = queryTracker;
        }

        public void initializeHook(TezProcessor source) {
            this.queryTracker.registerDagQueryId(new QueryIdentifier(source.getContext().getApplicationId().toString(), source.getContext().getDagIdentifier()), HiveConf.getVar((Configuration)source.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID));
        }
    }
}

