/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.Trace;
import java.util.Locale;

class ExecutionEnvironment {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";

    private ExecutionEnvironment() {
    }

    static int getBestGuessAS400Ccsid() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Getting best guess CCSID.");
        }
        try {
            String string = Locale.getDefault().toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Default Locale: " + string);
            }
            while (true) {
                String string2;
                if ((string2 = (String)ConversionMaps.localeCcsidMap_.get(string)) != null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Best guess for Locale: " + string + ", CCSID: " + string2);
                    }
                    return Integer.parseInt(string2);
                }
                string = string.substring(0, string.lastIndexOf(95));
            }
        }
        catch (Exception exception) {
            Trace.log(1, "Exception taking best guess CCSID, default to 37:", (Throwable)exception);
            return 37;
        }
    }

    static int getCcsid() {
        return 13488;
    }

    static int getCcsid(String string) {
        return Integer.parseInt((String)ConversionMaps.encodingCcsid_.get(string));
    }

    static String getEncoding(int n) {
        return (String)ConversionMaps.ccsidEncoding_.get(String.valueOf(n));
    }

    static String getNlv(Locale locale) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Getting NLV.");
        }
        try {
            String string = locale.toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "NLV Locale: " + string);
            }
            while (true) {
                String string2;
                if ((string2 = (String)ConversionMaps.localeNlvMap_.get(string)) != null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "NLV for Locale: " + string + ", NLV: " + string2);
                    }
                    return string2;
                }
                string = string.substring(0, string.lastIndexOf(95));
            }
        }
        catch (Exception exception) {
            Trace.log(1, "Exception getting NLV, default to 2924:", (Throwable)exception);
            return "2924";
        }
    }
}

