/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400CertificateAttribute;
import com.ibm.as400.access.AS400CertificateUsrPrfUtilImpl;
import com.ibm.as400.access.AS400CertificateUtil;
import com.ibm.as400.access.AS400CertificateUtilImpl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class AS400CertificateUserProfileUtil
extends AS400CertificateUtil
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    transient AS400CertificateUsrPrfUtilImpl usrprfImpl_ = null;

    public AS400CertificateUserProfileUtil() {
    }

    public AS400CertificateUserProfileUtil(AS400 aS400, String string) {
        super(aS400, string);
        if (!this.objectType_.equalsIgnoreCase("USRPRF") || this.objectName_.length() > 10) {
            throw new ExtendedIllegalArgumentException("path (" + string + ")", 3);
        }
        this.objectName_ = this.objectName_ + "          ";
        this.objectName_ = this.objectName_.substring(0, 10);
        this.objectName_ = this.objectName_.toUpperCase();
    }

    void connect() throws IOException {
        if (this.system_ == null) {
            Trace.log(2, "Parameter 'system' is null at connect.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.ifsPathName_ == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new ExtendedIllegalStateException("ifsPathName", 4);
        }
        this.usrprfImpl_ = (AS400CertificateUsrPrfUtilImpl)this.system_.loadImpl("com.ibm.as400.access.AS400CertificateUsrPrfUtilImplNative", "com.ibm.as400.access.AS400CertificateUsrPrfUtilImplRemote");
        this.impl_ = (AS400CertificateUtilImpl)this.system_.loadImpl("com.ibm.as400.access.AS400CertificateUtilImplNative", "com.ibm.as400.access.AS400CertificateUtilImplRemote");
        this.usrprfImpl_.system_ = this.system_;
        this.impl_.system_ = this.system_;
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        this.usrprfImpl_.setConverter(converter);
        this.impl_.setConverter(converter);
        this.connected_ = true;
    }

    public void addCertificate(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.usrprfImpl_.calladdCertificate(byArray, byArray.length, this.objectName_)) != 0) {
            this.throwException(this.usrprfImpl_.cpfError_, this.ifsPathName_, n);
        }
        this.fireAdd();
    }

    public void deleteCertificate(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.usrprfImpl_.calldeleteCertificate(byArray, byArray.length, this.objectName_, 1)) != 0) {
            this.throwException(this.usrprfImpl_.cpfError_, this.ifsPathName_, n);
        }
        this.fireDelete();
    }

    public void deleteCertificateByHandle(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificateHandle' is null.");
            throw new NullPointerException("certificateHandle");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.usrprfImpl_.calldeleteCertificate(byArray, byArray.length, this.objectName_, 2)) != 0) {
            this.throwException(this.usrprfImpl_.cpfError_, this.ifsPathName_, n);
        }
        this.fireDelete();
    }

    public String findCertificateUser(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.usrprfImpl_.callfindCertificateUser(byArray, byArray.length, 1)) != 0) {
            this.throwException(this.usrprfImpl_.cpfError_, this.ifsPathName_, n);
        }
        return null == this.usrprfImpl_.userName_ ? null : this.usrprfImpl_.userName_.trim();
    }

    public String findCertificateUserByHandle(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificateHandle' is null.");
            throw new NullPointerException("certificateHandle");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.usrprfImpl_.callfindCertificateUser(byArray, byArray.length, 2)) != 0) {
            this.throwException(this.usrprfImpl_.cpfError_, this.ifsPathName_, n);
        }
        return null == this.usrprfImpl_.userName_ ? null : this.usrprfImpl_.userName_.trim();
    }

    public int listCertificates(AS400CertificateAttribute[] aS400CertificateAttributeArray, String string) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected()) {
            this.connect();
        }
        boolean[] blArray = this.setSearchAttributes(aS400CertificateAttributeArray);
        String string2 = this.getAS400UserSpaceName(string);
        int n = this.usrprfImpl_.calllistCertificates(this.objectName_, string2, blArray, this.as400AttrS_, this.as400AttrB_);
        if (n != 0) {
            this.throwException(this.usrprfImpl_.cpfError_, this.ifsPathName_, n);
        }
        return this.usrprfImpl_.numberCertificatesFound_;
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        String string2 = qSYSObjectPathName.getLibraryName();
        String string3 = qSYSObjectPathName.getObjectName();
        String string4 = qSYSObjectPathName.getObjectType();
        if (null == string2 || null == string3 || string3.length() > 10 || !string4.equalsIgnoreCase("USRPRF")) {
            throw new ExtendedIllegalArgumentException("path", 3);
        }
        string3 = string3 + "          ";
        string3 = string3.substring(0, 10);
        string3 = string3.toUpperCase();
        if (this.ifsPathName_ == null) {
            this.ifsPathName_ = string;
            this.libName_ = string2;
            this.objectName_ = string3;
            this.objectType_ = string4;
        } else {
            if (this.system_ != null && this.isConnected()) {
                Trace.log(2, "Parameter 'path' is not changed (Connected=true).");
                throw new ExtendedIllegalStateException("path", 5);
            }
            String string5 = this.ifsPathName_;
            this.vetos_.fireVetoableChange("path", string5, string);
            this.ifsPathName_ = string;
            this.libName_ = string2;
            this.objectName_ = string3;
            this.objectType_ = string4;
            this.changes_.firePropertyChange("path", string5, string);
        }
    }
}

