/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.metainject.analyzer;

import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;

public class MetaInjectAnalyzer
extends StepAnalyzer<MetaInjectMeta> {
    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supported = new HashSet<Class<? extends BaseStepMeta>>();
        supported.add(MetaInjectMeta.class);
        return supported;
    }

    protected Set<StepField> getUsedFields(MetaInjectMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        for (Map.Entry<TargetStepAttribute, SourceStepField> entry : meta.getTargetSourceMapping().entrySet()) {
            SourceStepField value = entry.getValue();
            for (StepField stepField : this.createStepFields(value.getField(), this.getInputs())) {
                usedFields.add(stepField);
            }
        }
        return usedFields;
    }

    protected void customAnalyze(MetaInjectMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        String sourceStepName = this.parentTransMeta.environmentSubstitute(meta.getSourceStepName());
        rootNode.setProperty("sourceStepName", (Object)sourceStepName);
        rootNode.setProperty("targetFile", (Object)this.parentTransMeta.environmentSubstitute(meta.getTargetFile()));
        rootNode.setProperty("streamSourceStepname", (Object)this.parentTransMeta.environmentSubstitute(meta.getStreamSourceStepname()));
        rootNode.setProperty("streamTargetStepname", (Object)this.parentTransMeta.environmentSubstitute(meta.getStreamTargetStepname()));
        rootNode.setProperty("runResultingTransformation", (Object)(!meta.isNoExecution() ? 1 : 0));
        KettleAnalyzerUtil.analyze((StepAnalyzer)this, (TransMeta)this.parentTransMeta, (ISubTransAwareMeta)meta, (IMetaverseNode)rootNode);
    }

    private List<String> getOutputFieldNames(TransMeta transMeta, String stepName) {
        Map targetFieldsMap = this.getOutputRowMetaInterfaces(transMeta, transMeta.findStep(stepName), null, false);
        ArrayList<String> targetFieldNames = new ArrayList<String>();
        if (targetFieldsMap != null) {
            List fieldValues = ((RowMetaInterface)targetFieldsMap.values().iterator().next()).getValueMetaList();
            for (ValueMetaInterface fieldValue : fieldValues) {
                targetFieldNames.add(fieldValue.getName());
            }
        }
        return targetFieldNames;
    }

    public void postAnalyze(MetaInjectMeta meta) throws MetaverseAnalyzerException {
        String transformationPath = this.parentTransMeta.environmentSubstitute(meta.getFileName());
        TransMeta subTransMeta = KettleAnalyzerUtil.getSubTransMeta((ISubTransAwareMeta)meta);
        subTransMeta.setFilename(transformationPath);
        Vertex stepVertex = this.findStepVertex(this.parentTransMeta, this.parentStepMeta.getName());
        if (!StringUtil.isEmpty((String)meta.getStreamSourceStepname()) && !StringUtil.isEmpty((String)meta.getStreamTargetStepname())) {
            List<String> sourceFieldNames = this.getOutputFieldNames(this.parentTransMeta, meta.getStreamSourceStepname());
            List<String> targetFieldNames = this.getOutputFieldNames(subTransMeta, meta.getStreamTargetStepname());
            int index = 0;
            for (String sourceFieldName : sourceFieldNames) {
                Vertex streamSourceStepOutputField = this.findFieldVertex(this.parentTransMeta, meta.getStreamSourceStepname(), sourceFieldName);
                if (index >= targetFieldNames.size()) break;
                Vertex streamTargetStepOutputField = this.findFieldVertex(subTransMeta, meta.getStreamTargetStepname(), targetFieldNames.get(index++));
                this.getMetaverseBuilder().addLink(streamSourceStepOutputField, "derives", streamTargetStepOutputField);
            }
        }
        String sourceStepName = this.parentTransMeta.environmentSubstitute(meta.getSourceStepName());
        Iterator<Map.Entry<TargetStepAttribute, SourceStepField>> fieldMappingsIter = meta.getTargetSourceMapping().entrySet().iterator();
        ArrayList<String> verboseProperties = new ArrayList<String>();
        int mappingCount = 1;
        int ignoredMappingCount = 1;
        while (fieldMappingsIter.hasNext()) {
            String mappingKey;
            Map.Entry<TargetStepAttribute, SourceStepField> entry = fieldMappingsIter.next();
            TargetStepAttribute targetTemplateStepAttr = entry.getKey();
            SourceStepField sourceInjectorStepField = entry.getValue();
            String targetTemplateStepName = targetTemplateStepAttr.getStepname();
            boolean ignoreMapping = sourceInjectorStepField.getStepname().equalsIgnoreCase(meta.getStreamSourceStepname());
            if (!ignoreMapping) {
                mappingKey = "mapping [" + mappingCount++ + "]";
                if (targetTemplateStepName.equalsIgnoreCase(sourceStepName)) {
                    List targetTemplateFields = this.findFieldVertices(subTransMeta, targetTemplateStepName);
                    for (Vertex targetTemplateField : targetTemplateFields) {
                        this.getMetaverseBuilder().addLink(targetTemplateField, "inputs", stepVertex);
                    }
                }
                Vertex targetTemplateStepVertex = this.findStepVertex(subTransMeta, targetTemplateStepName);
                IMetaverseNode subTransPropertyNode = this.getNode(targetTemplateStepAttr.getAttributeKey(), "Transformation Step property", (String)targetTemplateStepVertex.getProperty("logicalId"), targetTemplateStepName + ":" + targetTemplateStepAttr.getAttributeKey(), null);
                this.getMetaverseBuilder().addNode(subTransPropertyNode);
                Vertex subTransPropertyVertex = this.findVertexById(subTransPropertyNode.getStringID());
                if (subTransPropertyVertex != null) {
                    this.getMetaverseBuilder().addLink(targetTemplateStepVertex, "contains", subTransPropertyVertex);
                }
                String injectorStepName = sourceInjectorStepField.getStepname();
                String injectotFieldName = sourceInjectorStepField.getField();
                IMetaverseNode matchingInjectorFieldNode = this.getInputs().findNode(injectorStepName, injectotFieldName);
                if (matchingInjectorFieldNode != null) {
                    this.getMetaverseBuilder().addLink(matchingInjectorFieldNode, "populates", subTransPropertyNode);
                }
            } else {
                mappingKey = "ignored mapping [" + ignoredMappingCount++ + "]";
            }
            StringBuilder mapping = new StringBuilder();
            mapping.append(sourceInjectorStepField.getStepname()).append(": ").append(sourceInjectorStepField.getField()).append(" > [").append(subTransMeta.getName()).append("] ").append(targetTemplateStepName).append(": ").append(targetTemplateStepAttr.getAttributeKey());
            verboseProperties.add(mappingKey);
            stepVertex.setProperty(mappingKey, (Object)mapping.toString());
        }
        if (StringUtils.isNotBlank((String)sourceStepName)) {
            List sourceStepFields = this.findFieldVertices(subTransMeta, sourceStepName);
            for (Vertex sourceStepField : sourceStepFields) {
                this.getMetaverseBuilder().addLink(sourceStepField, "inputs", stepVertex);
                Vertex derivedField = this.findFieldVertex(this.parentTransMeta, stepVertex.getProperty("name").toString(), sourceStepField.getProperty("name").toString());
                if (derivedField == null) continue;
                this.getMetaverseBuilder().addLink(sourceStepField, "derives", derivedField);
            }
        }
        stepVertex.setProperty("verboseDetails", (Object)StringUtils.join(verboseProperties, (String)","));
    }

    protected IClonableStepAnalyzer newInstance() {
        return new MetaInjectAnalyzer();
    }
}

