/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.types;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.pentaho.requirejs.IRequireJsPackage;

public class MetaInfRequireJson
implements IRequireJsPackage {
    private final Map<String, Object> requireJsonObject;
    private final Map<String, String> modules;
    private final Map<String, String> packages;
    private final Map<String, String> dependencies;
    private final Map<String, Map<String, ?>> config;
    private final Map<String, Map<String, String>> localMap;
    private final Map<String, Map<String, ?>> shim;
    private String name;
    private String version;
    private boolean isAmdPackage;
    private String exports;

    public MetaInfRequireJson(Map<String, Object> requireJsonObject) {
        this.requireJsonObject = requireJsonObject;
        this.modules = new HashMap<String, String>();
        this.packages = new HashMap<String, String>();
        this.dependencies = new HashMap<String, String>();
        this.config = new HashMap();
        this.localMap = new HashMap<String, Map<String, String>>();
        this.shim = new HashMap();
        this.isAmdPackage = true;
        this.init();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getWebRootPath() {
        return this.name.isEmpty() ? "" : this.name + "@" + this.version;
    }

    public boolean preferGlobal() {
        return this.name.isEmpty();
    }

    private void addModule(String moduleId, String path) {
        this.modules.put(moduleId, path);
    }

    private void addModule(String moduleId, String path, String main) {
        this.modules.put(moduleId, path);
        this.packages.put(moduleId, main);
    }

    private void removeModule(String moduleId) {
        this.modules.remove(moduleId);
        this.packages.remove(moduleId);
    }

    public Map<String, String> getModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    public String getModuleMainFile(String moduleId) {
        return this.packages.get(moduleId);
    }

    private void addDependency(String packageName, String version) {
        this.dependencies.put(packageName, version);
    }

    private void removeDependency(String packageName) {
        this.dependencies.remove(packageName);
    }

    public Map<String, String> getDependencies() {
        return Collections.unmodifiableMap(this.dependencies);
    }

    public boolean hasScript(String name) {
        return false;
    }

    public URL getScriptResource(String name) {
        return null;
    }

    private void addConfig(String moduleId, Map<String, ?> configuration) {
        this.config.put(moduleId, configuration);
    }

    private void removeConfig(String moduleId) {
        this.config.remove(moduleId);
    }

    public Map<String, Map<String, ?>> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    private void addMap(String where, String originalModuleId, String mappedModuleId) {
        this.localMap.computeIfAbsent(where, m -> new HashMap()).put(originalModuleId, mappedModuleId);
    }

    private void removeMap(String where) {
        this.removeMap(where, null);
    }

    private void removeMap(String where, String originalModuleId) {
        if (this.localMap.containsKey(where)) {
            if (originalModuleId != null) {
                this.localMap.get(where).remove(originalModuleId);
            } else {
                this.localMap.remove(where);
            }
        }
    }

    public Map<String, Map<String, String>> getMap() {
        return Collections.unmodifiableMap(this.localMap);
    }

    private void addShim(String moduleId, Map<String, ?> configuration) {
        this.shim.put(moduleId, configuration);
    }

    private void removeShim(String moduleId) {
        this.shim.remove(moduleId);
    }

    public Map<String, Map<String, ?>> getShim() {
        return this.shim;
    }

    public boolean isAmdPackage() {
        return this.isAmdPackage;
    }

    public String getExports() {
        return this.exports;
    }

    private void init() {
        this.initFromRequireJson(this.requireJsonObject);
    }

    private void initFromRequireJson(Map<String, Object> json) {
        Map config;
        this.name = "";
        this.version = "";
        String artifactId = null;
        HashMap<String, String> moduleIdTranslator = new HashMap<String, String>();
        HashMap meta = (HashMap)json.get("requirejs-osgi-meta");
        HashMap availableModules = meta != null && meta.containsKey("modules") ? (HashMap)meta.get("modules") : new HashMap();
        if (meta != null && meta.containsKey("artifacts")) {
            HashMap artifacts = (HashMap)meta.get("artifacts");
            Map.Entry nameEntry = artifacts.entrySet().iterator().next();
            artifactId = (String)nameEntry.getKey();
            int indexOfSlash = artifactId.lastIndexOf(47);
            if (indexOfSlash != -1) {
                artifactId = artifactId.substring(indexOfSlash + 1);
            }
            Map.Entry versionEntry = ((HashMap)nameEntry.getValue()).entrySet().iterator().next();
            this.version = (String)versionEntry.getKey();
            HashMap versionInfo = (HashMap)versionEntry.getValue();
            this.name = versionInfo.size() == 1 ? (String)versionInfo.keySet().iterator().next() : artifactId;
        }
        if (this.name.isEmpty() && availableModules.size() > 0) {
            String versionEntry;
            Map.Entry nameEntry = availableModules.entrySet().iterator().next();
            this.name = (String)nameEntry.getKey();
            this.version = versionEntry = (String)((HashMap)nameEntry.getValue()).keySet().iterator().next();
        }
        if (artifactId != null) {
            moduleIdTranslator.put(artifactId + "@" + this.version, this.name);
        }
        ArrayList basePaths = new ArrayList();
        availableModules.forEach((moduleId, versions) -> versions.forEach((version, moduleInfo) -> {
            boolean isAmdModule;
            moduleIdTranslator.put(moduleId + "@" + version, (String)moduleId);
            basePaths.add(moduleId + "@" + version);
            basePaths.add("/" + moduleId + "@" + version);
            if (moduleInfo.containsKey("dependencies")) {
                HashMap dependencies = (HashMap)moduleInfo.get("dependencies");
                for (String dependencyId : dependencies.keySet()) {
                    String versionRequirement = (String)dependencies.get(dependencyId);
                    this.addDependency(dependencyId, versionRequirement);
                }
            }
            boolean bl = isAmdModule = moduleInfo.containsKey("isAmdPackage") && (Boolean)moduleInfo.get("isAmdPackage") != false;
            if (!isAmdModule && moduleInfo.containsKey("exports")) {
                this.exports = (String)moduleInfo.get("exports");
            }
            this.isAmdPackage = this.isAmdPackage && isAmdModule;
        }));
        if (json.containsKey("paths")) {
            Map paths = (Map)json.get("paths");
            paths.forEach((moduleId, pathObj) -> {
                if (pathObj instanceof String) {
                    String path = (String)pathObj;
                    String unversionedModuleId = this.getUnversionedModuleId(moduleIdTranslator, (String)moduleId);
                    String unversionedPath = this.getUnversionedPath(basePaths, path);
                    this.addModule(unversionedModuleId, unversionedPath);
                }
            });
        }
        if (json.containsKey("packages")) {
            List packages = (List)json.get("packages");
            packages.forEach(packageDefinition -> {
                HashMap packageObj;
                if (packageDefinition instanceof String) {
                    String packageName = this.getUnversionedModuleId(moduleIdTranslator, (String)packageDefinition);
                    String path = this.modules.getOrDefault(packageName, "/" + packageName);
                    path = this.getUnversionedPath(basePaths, path);
                    this.addModule(packageName, path, "main");
                } else if (packageDefinition instanceof HashMap && (packageObj = (HashMap)packageDefinition).containsKey("name")) {
                    String packageName = this.getUnversionedModuleId(moduleIdTranslator, (String)packageObj.get("name"));
                    String path = packageObj.getOrDefault("location", "/" + (!packageName.equals(this.name) ? packageName : ""));
                    String mainScript = packageObj.getOrDefault("main", "main");
                    path = this.getUnversionedPath(basePaths, path);
                    this.addModule(packageName, path, mainScript);
                }
            });
        }
        if (json.containsKey("config")) {
            config = (Map)json.get("config");
            config.forEach((originalModuleId, configuration) -> {
                String unversionedModuleId = this.getUnversionedModuleId(moduleIdTranslator, (String)originalModuleId);
                if (configuration instanceof Map) {
                    this.addConfig(unversionedModuleId, (Map)configuration);
                }
            });
        }
        if (json.containsKey("map")) {
            Map mappings = (Map)json.get("map");
            mappings.forEach((where, map) -> map.forEach((originalModuleId, mappedModuleId) -> {
                String unversionedWhere = this.getUnversionedModuleId(moduleIdTranslator, (String)where);
                if (mappedModuleId instanceof String) {
                    this.addMap(unversionedWhere, this.getUnversionedModuleId(moduleIdTranslator, (String)originalModuleId), this.getUnversionedModuleId(moduleIdTranslator, (String)mappedModuleId));
                }
            }));
        }
        if (json.containsKey("shim")) {
            config = (Map)json.get("shim");
            config.forEach((originalModuleId, configuration) -> {
                String unversionedModuleId = this.getUnversionedModuleId(moduleIdTranslator, (String)originalModuleId);
                if (configuration instanceof Map) {
                    this.addShim(unversionedModuleId, (Map)configuration);
                } else if (configuration instanceof List) {
                    HashMap<String, Object> cfg = new HashMap<String, Object>();
                    cfg.put("deps", configuration);
                    this.addShim(unversionedModuleId, cfg);
                }
            });
        }
        if (meta != null && meta.containsKey("overrides")) {
            Map overrides = meta.getOrDefault("overrides", Collections.emptyMap());
            if (overrides.containsKey("dependencies")) {
                HashMap dependencies = (HashMap)overrides.get("dependencies");
                dependencies.forEach((dependencyId, versionRequirement) -> {
                    if (versionRequirement instanceof String) {
                        this.addDependency((String)dependencyId, (String)versionRequirement);
                    } else {
                        this.removeDependency((String)dependencyId);
                    }
                });
            }
            if (overrides.containsKey("paths")) {
                Map paths = (Map)overrides.get("paths");
                paths.forEach((moduleId, path) -> {
                    if (path instanceof String) {
                        this.addModule((String)moduleId, (String)path);
                    } else {
                        this.removeModule((String)moduleId);
                    }
                });
            }
            if (overrides.containsKey("packages")) {
                List packages = (List)overrides.get("packages");
                packages.forEach(packageDefinition -> {
                    HashMap packageObj;
                    if (packageDefinition instanceof String) {
                        String packageName = (String)packageDefinition;
                        String path = this.modules.getOrDefault(packageName, "/" + packageName);
                        path = this.getUnversionedPath(basePaths, path);
                        this.addModule(packageName, path, "main");
                    } else if (packageDefinition instanceof HashMap && (packageObj = (HashMap)packageDefinition).containsKey("name")) {
                        String packageName = (String)packageObj.get("name");
                        String path = packageObj.getOrDefault("location", "/" + (!packageName.equals(this.name) ? packageName : ""));
                        String mainScript = packageObj.getOrDefault("main", "main");
                        path = this.getUnversionedPath(basePaths, path);
                        this.addModule(packageName, path, mainScript);
                    }
                });
            }
            if (overrides.containsKey("config")) {
                Map config2 = (Map)overrides.get("config");
                config2.forEach((moduleId, configuration) -> {
                    if (configuration instanceof Map) {
                        this.addConfig((String)moduleId, (Map)configuration);
                    } else {
                        this.removeConfig((String)moduleId);
                    }
                });
            }
            if (overrides.containsKey("map")) {
                Map mappings = (Map)overrides.get("map");
                mappings.forEach((where, map) -> {
                    if (map instanceof Map) {
                        ((Map)map).forEach((originalModuleId, mappedModuleId) -> {
                            if (mappedModuleId instanceof String) {
                                this.addMap((String)where, (String)originalModuleId, (String)mappedModuleId);
                            } else {
                                this.removeMap((String)where, (String)originalModuleId);
                            }
                        });
                    } else {
                        this.removeMap((String)where);
                    }
                });
            }
            if (overrides.containsKey("shim")) {
                Map config3 = (Map)overrides.get("shim");
                config3.forEach((originalModuleId, configuration) -> {
                    if (configuration instanceof Map) {
                        this.addShim((String)originalModuleId, (Map)configuration);
                    } else {
                        this.removeShim((String)originalModuleId);
                    }
                });
            }
        }
    }

    private String getUnversionedPath(List<String> basePaths, String path) {
        String basePath = basePaths.stream().filter(path::startsWith).findFirst().orElse(null);
        String unversionedPath = basePath != null ? path.replaceFirst(Pattern.quote(basePath), "") : path;
        if (!unversionedPath.startsWith("/")) {
            unversionedPath = "/" + unversionedPath;
        }
        return unversionedPath;
    }

    private String getUnversionedModuleId(HashMap<String, String> moduleIdTranslator, String moduleId) {
        if (!moduleIdTranslator.isEmpty()) {
            String baseModuleId = moduleIdTranslator.keySet().stream().filter(moduleId::startsWith).findFirst().orElse(moduleId);
            String replacement = moduleIdTranslator.get(baseModuleId);
            if (replacement != null) {
                return moduleId.replaceFirst(Pattern.quote(baseModuleId), replacement);
            }
        }
        return moduleId;
    }
}

