/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.listeners;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.pentaho.requirejs.IPlatformPluginRequireJsConfigurations;
import org.pentaho.requirejs.IRequireJsPackage;
import org.pentaho.requirejs.impl.RequireJsConfigManager;
import org.pentaho.requirejs.impl.types.BundledPlatformPluginRequireJsConfigurations;
import org.pentaho.requirejs.impl.types.MetaInfPackageJson;
import org.pentaho.requirejs.impl.types.MetaInfRequireJson;

public class RequireJsBundleListener
implements BundleListener {
    static final String PACKAGE_JSON_PATH = "META-INF/js/package.json";
    static final String REQUIRE_JSON_PATH = "META-INF/js/require.json";
    public static final String EXTERNAL_RESOURCES_JSON_PATH = "META-INF/js/externalResources.json";
    public static final String STATIC_RESOURCES_JSON_PATH = "META-INF/js/staticResources.json";
    private BundleContext bundleContext;
    private RequireJsConfigManager requireJsConfigManager;
    private Map<Long, ServiceRegistration<?>> serviceRegistrationMap;
    private Map<Long, IPlatformPluginRequireJsConfigurations> requireConfigMap;
    private JSONParser parser;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setRequireJsConfigManager(RequireJsConfigManager requireJsConfigManager) {
        this.requireJsConfigManager = requireJsConfigManager;
    }

    public void init() {
        this.parser = new JSONParser();
        this.serviceRegistrationMap = new ConcurrentHashMap();
        this.requireConfigMap = new ConcurrentHashMap<Long, IPlatformPluginRequireJsConfigurations>();
        this.bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.addBundle(bundle);
        }
    }

    public void destroy() {
        this.serviceRegistrationMap = null;
        this.requireConfigMap = null;
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public Collection<IPlatformPluginRequireJsConfigurations> getScripts() {
        return Collections.unmodifiableCollection(this.requireConfigMap.values());
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if (this.isListenerActive()) {
            Bundle bundle = bundleEvent.getBundle();
            int bundleEventType = bundleEvent.getType();
            boolean shouldInvalidate = false;
            if (bundleEventType == 2) {
                shouldInvalidate = this.addBundle(bundle);
            } else if (bundleEventType == 16 || bundleEventType == 64 || bundleEventType == 4) {
                shouldInvalidate = this.removeBundle(bundle);
            }
            if (shouldInvalidate && this.isListenerActive()) {
                this.requireJsConfigManager.invalidateCachedConfigurations();
            }
        }
    }

    public boolean removeBundle(Bundle bundle) {
        return this.removeBundleInternal(bundle);
    }

    private boolean removeBundleInternal(Bundle bundle) {
        IPlatformPluginRequireJsConfigurations requireJsConfiguration;
        ServiceRegistration<?> serviceRegistration = this.serviceRegistrationMap.remove(bundle.getBundleId());
        if (serviceRegistration != null) {
            try {
                serviceRegistration.unregister();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return (requireJsConfiguration = this.requireConfigMap.remove(bundle.getBundleId())) != null;
    }

    boolean addBundle(Bundle bundle) {
        boolean shouldInvalidate;
        try {
            Map<String, Object> packageJsonObject;
            ServiceRegistration serviceRegistration;
            Object packageInfo;
            if (bundle.getState() != 32) {
                return false;
            }
            shouldInvalidate = this.removeBundleInternal(bundle);
            URL packageJsonUrl = bundle.getResource(PACKAGE_JSON_PATH);
            URL configFileUrl = bundle.getResource(REQUIRE_JSON_PATH);
            URL externalResourcesUrl = bundle.getResource(EXTERNAL_RESOURCES_JSON_PATH);
            URL staticResourcesUrl = bundle.getResource(STATIC_RESOURCES_JSON_PATH);
            if (configFileUrl != null) {
                Map<String, Object> requireJsonObject = this.loadJsonObject(configFileUrl);
                if (requireJsonObject != null) {
                    packageInfo = new MetaInfRequireJson(requireJsonObject);
                    serviceRegistration = bundle.getBundleContext().registerService(IRequireJsPackage.class.getName(), packageInfo, null);
                    this.serviceRegistrationMap.put(bundle.getBundleId(), serviceRegistration);
                }
            } else if (packageJsonUrl != null && (packageJsonObject = this.loadJsonObject(packageJsonUrl)) != null) {
                packageInfo = new MetaInfPackageJson(packageJsonObject);
                serviceRegistration = bundle.getBundleContext().registerService(IRequireJsPackage.class.getName(), packageInfo, null);
                this.serviceRegistrationMap.put(bundle.getBundleId(), serviceRegistration);
            }
            if (externalResourcesUrl != null) {
                List<String> requireJsList;
                Map<String, Object> externalResourceJsonObject = this.loadJsonObject(externalResourcesUrl);
                Map<String, Object> staticResourceJsonObject = this.loadJsonObject(staticResourcesUrl);
                if (externalResourceJsonObject != null && (requireJsList = this.getRequireJsList(externalResourceJsonObject, staticResourceJsonObject)) != null) {
                    this.requireConfigMap.put(bundle.getBundleId(), new BundledPlatformPluginRequireJsConfigurations(bundle, requireJsList));
                    shouldInvalidate = true;
                }
            }
        }
        catch (Exception e) {
            shouldInvalidate = true;
        }
        return shouldInvalidate;
    }

    private List<String> getRequireJsList(Map<String, Object> externalResourceJsonObject, Map<String, Object> staticResourceJsonObject) {
        ArrayList<String> requireJsList = (ArrayList<String>)externalResourceJsonObject.get("requirejs");
        if (requireJsList != null && staticResourceJsonObject != null) {
            ArrayList<String> translatedList = new ArrayList<String>(requireJsList.size());
            for (String element : requireJsList) {
                boolean found = false;
                for (String key : staticResourceJsonObject.keySet()) {
                    String strKey = key.toString();
                    if (!element.startsWith(strKey)) continue;
                    String value = staticResourceJsonObject.get(key).toString();
                    translatedList.add(value + element.substring(strKey.length()));
                    found = true;
                    break;
                }
                if (found) continue;
                translatedList.add(element);
            }
            requireJsList = translatedList;
        }
        return requireJsList;
    }

    private boolean isListenerActive() {
        return this.requireConfigMap != null && this.serviceRegistrationMap != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadJsonObject(URL url) throws IOException, ParseException {
        if (url == null) {
            return null;
        }
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            URLConnection urlConnection = url.openConnection();
            inputStream = urlConnection.getInputStream();
            inputStreamReader = new InputStreamReader(urlConnection.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            Map map = (Map)this.parser.parse((Reader)bufferedReader);
            return map;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

