/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class FilterListBase
extends FilterBase {
    private static final int MAX_LOG_FILTERS = 5;
    protected final ArrayList<Filter> filters;
    protected ArrayList<Boolean> subFiltersIncludedCell;

    public FilterListBase(List<Filter> filters) {
        this.reversed = FilterListBase.checkAndGetReversed(filters, this.reversed);
        this.filters = new ArrayList<Filter>(filters);
    }

    protected static boolean isInReturnCodes(Filter.ReturnCode testRC, Filter.ReturnCode ... returnCodes) {
        return Arrays.stream(returnCodes).anyMatch(testRC::equals);
    }

    protected static boolean checkAndGetReversed(List<Filter> rowFilters, boolean defaultValue) {
        if (rowFilters.isEmpty()) {
            return defaultValue;
        }
        boolean retValue = rowFilters.get(0).isReversed();
        boolean allEqual = rowFilters.stream().allMatch(f -> f.isReversed() == retValue);
        if (!allEqual) {
            throw new IllegalArgumentException("Filters in the list must have the same reversed flag");
        }
        return retValue;
    }

    public abstract void addFilterLists(List<Filter> var1);

    public int size() {
        return this.filters.size();
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public ArrayList<Filter> getFilters() {
        return this.filters;
    }

    protected int compareCell(Cell a, Cell b) {
        int cmp = CellComparator.getInstance().compare(a, b);
        return this.reversed ? -1 * cmp : cmp;
    }

    @Override
    public Cell transformCell(Cell c) throws IOException {
        if (this.isEmpty()) {
            return super.transformCell(c);
        }
        Cell transformed = c;
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            if (!this.subFiltersIncludedCell.get(i).booleanValue()) continue;
            transformed = this.filters.get(i).transformCell(transformed);
        }
        return transformed;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell c) throws IOException {
        return this.filterCell(c);
    }

    @Override
    public void filterRowCells(List<Cell> cells) throws IOException {
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            this.filters.get(i).filterRowCells(cells);
        }
    }

    @Override
    public boolean hasFilterRow() {
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            if (!this.filters.get(i).hasFilterRow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFamilyEssential(byte[] name) throws IOException {
        if (this.filters.isEmpty()) {
            return super.isFamilyEssential(name);
        }
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            if (!this.filters.get(i).isFamilyEssential(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setReversed(boolean reversed) {
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            this.filters.get(i).setReversed(reversed);
        }
        this.reversed = reversed;
    }

    @Override
    public String toString() {
        int endIndex = this.size() < 5 ? this.size() : 5;
        return this.formatLogFilters(this.filters.subList(0, endIndex));
    }

    protected abstract String formatLogFilters(List<Filter> var1);
}

