/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.schshim;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.schshim.FairSchedulerQueueAllocator;
import org.apache.hadoop.hive.schshim.QueueAllocator;
import org.apache.hadoop.hive.shims.SchedulerShim;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FairSchedulerShim
implements SchedulerShim {
    private static final Logger LOG = LoggerFactory.getLogger(FairSchedulerShim.class);
    private static final String MR2_JOB_QUEUE_PROPERTY = "mapreduce.job.queuename";
    private final QueueAllocator queueAllocator;

    @VisibleForTesting
    public FairSchedulerShim(QueueAllocator queueAllocator) {
        this.queueAllocator = queueAllocator;
    }

    public FairSchedulerShim() {
        this(new FairSchedulerQueueAllocator());
    }

    public synchronized void refreshDefaultQueue(Configuration conf, String forUser) throws IOException {
        this.setJobQueueForUserInternal(conf, "default", forUser);
    }

    public synchronized void validateQueueConfiguration(Configuration conf, String forUser) throws IOException {
        String currentJobQueue = conf.get(MR2_JOB_QUEUE_PROPERTY);
        if (currentJobQueue != null && !currentJobQueue.isEmpty()) {
            this.setJobQueueForUserInternal(conf, currentJobQueue, forUser);
        } else {
            this.refreshDefaultQueue(conf, forUser);
        }
    }

    public QueueAllocator getQueueAllocator() {
        return this.queueAllocator;
    }

    private void setJobQueueForUserInternal(Configuration conf, String queueName, String forUser) throws IOException {
        QueuePlacementPolicy queuePolicy = this.queueAllocator.makeConfigurationFor(conf, forUser).get().getPlacementPolicy();
        if (queuePolicy != null) {
            String requestedQueue = queuePolicy.assignAppToQueue(queueName, forUser);
            if (StringUtils.isNotBlank((String)requestedQueue)) {
                LOG.info("Setting queue name to: '{}' for user '{}'", (Object)requestedQueue, (Object)forUser);
                conf.set(MR2_JOB_QUEUE_PROPERTY, requestedQueue);
            } else {
                requestedQueue = queuePolicy.assignAppToQueue("default", forUser);
                if (StringUtils.isNotBlank((String)requestedQueue)) {
                    LOG.warn("Unable to set queue: {} for user: {}, resetting to user's default queue.", (Object)requestedQueue, (Object)forUser);
                } else {
                    LOG.warn("Unable to set queue for: {}", (Object)forUser);
                }
            }
        }
    }
}

